/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.util;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import de.justsoftware.mobile.gateway.exception.CommentTooLongException;
import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.exception.GraphQLException;
import de.justsoftware.mobile.gateway.exception.PostAlreadyUpdatedException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\u001a*\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0012H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0010*\u00020\u0012H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0012H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0010*\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u0001*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\"\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u0001*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001c\u00a8\u0006!"}, d2={"KEY_ERROR_TYPE", "", "KEY_ERROR_CODE", "KEY_API_ERROR", "ERROR_TYPE_PERMISSION_DENIED", "ERROR_CODE_NOT_ALLOWED", "POST_ALREADY_UPDATED_ERROR", "handleErrors", "", "T", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "logger", "Lorg/slf4j/Logger;", "operationName", "hasPermissionDenied", "", "", "Lcom/apollographql/apollo3/api/Error;", "hasNotAllowed", "hasPostAlreadyUpdated", "hasCommentTooLong", "isPermissionDenied", "isNotAllowed", "isPostAlreadyUpdated", "isCommentTooLong", "errorType", "getErrorType", "(Lcom/apollographql/apollo3/api/Error;)Ljava/lang/String;", "errorCode", "getErrorCode", "apiError", "getApiError", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Errors.kt\nde/justsoftware/mobile/gateway/util/ErrorsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1863#2,2:66\n1755#2,3:68\n1755#2,3:71\n1755#2,3:74\n1755#2,3:77\n*S KotlinDebug\n*F\n+ 1 Errors.kt\nde/justsoftware/mobile/gateway/util/ErrorsKt\n*L\n25#1:66,2\n44#1:68,3\n45#1:71,3\n47#1:74,3\n48#1:77,3\n*E\n"})
public final class ErrorsKt {
    @NotNull
    private static final String KEY_ERROR_TYPE = "errorType";
    @NotNull
    private static final String KEY_ERROR_CODE = "code";
    @NotNull
    private static final String KEY_API_ERROR = "apiError";
    @NotNull
    private static final String ERROR_TYPE_PERMISSION_DENIED = "PERMISSION_DENIED";
    @NotNull
    private static final String ERROR_CODE_NOT_ALLOWED = "NOT_ALLOWED";
    @NotNull
    private static final String POST_ALREADY_UPDATED_ERROR = "POST_ALREADY_UPDATED_ERROR";

    public static final <T extends Operation.Data> void handleErrors(@NotNull ApolloResponse<T> $this$handleErrors, @NotNull Logger logger, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter($this$handleErrors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        List list = $this$handleErrors.errors;
        if (list == null) {
            return;
        }
        List errors = list;
        Iterable $this$forEach$iv = errors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Error error = (Error)element$iv;
            boolean bl = false;
            logger.error("Error while executing GraphQL-Query " + operationName + ": " + error);
        }
        if (ErrorsKt.hasPermissionDenied((List)errors) || ErrorsKt.hasNotAllowed((List)errors)) {
            throw new ForbiddenException("User is not authorized to execute GraphQL-Query " + operationName + ".");
        }
        if (ErrorsKt.hasPostAlreadyUpdated((List)errors)) {
            throw new PostAlreadyUpdatedException();
        }
        if (ErrorsKt.hasCommentTooLong((List)errors)) {
            throw new CommentTooLongException();
        }
        throw new GraphQLException("Error(s) occurred executing GraphQL-Query. See server log for details.");
    }

    private static final boolean hasPermissionDenied(List<Error> $this$hasPermissionDenied) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasPermissionDenied;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isPermissionDenied((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasNotAllowed(List<Error> $this$hasNotAllowed) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasNotAllowed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isNotAllowed((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasPostAlreadyUpdated(List<Error> $this$hasPostAlreadyUpdated) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasPostAlreadyUpdated;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isPostAlreadyUpdated((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasCommentTooLong(List<Error> $this$hasCommentTooLong) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasCommentTooLong;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isCommentTooLong((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isPermissionDenied(Error $this$isPermissionDenied) {
        return Intrinsics.areEqual((Object)ErrorsKt.getErrorType((Error)$this$isPermissionDenied), (Object)"PERMISSION_DENIED");
    }

    private static final boolean isNotAllowed(Error $this$isNotAllowed) {
        return Intrinsics.areEqual((Object)ErrorsKt.getErrorCode((Error)$this$isNotAllowed), (Object)"NOT_ALLOWED");
    }

    private static final boolean isPostAlreadyUpdated(Error $this$isPostAlreadyUpdated) {
        return Intrinsics.areEqual((Object)ErrorsKt.getApiError((Error)$this$isPostAlreadyUpdated), (Object)"POST_ALREADY_UPDATED_ERROR");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCommentTooLong(Error $this$isCommentTooLong) {
        List list = $this$isCommentTooLong.getPath();
        if (!(list != null ? list.contains("addComment") : false)) {
            List list2 = $this$isCommentTooLong.getPath();
            if (list2 == null) return false;
            if (!list2.contains("updateComment")) return false;
            boolean bl = true;
            if (!bl) return false;
        }
        if (!StringsKt.contains$default((CharSequence)$this$isCommentTooLong.getMessage(), (CharSequence)"Exceeded maximum of 5000 characters", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final String getErrorType(Error $this$errorType) {
        Map map = $this$errorType.getExtensions();
        Object v = map != null ? map.get("errorType") : null;
        return v instanceof String ? (String)v : null;
    }

    private static final String getErrorCode(Error $this$errorCode) {
        Map map = $this$errorCode.getExtensions();
        Object v = map != null ? map.get("code") : null;
        return v instanceof String ? (String)v : null;
    }

    private static final String getApiError(Error $this$apiError) {
        Map map = $this$apiError.getExtensions();
        Object v = map != null ? map.get("apiError") : null;
        return v instanceof String ? (String)v : null;
    }
}

