/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.service;

import de.justsoftware.mobile.gateway.news.model.NewsConfig;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService;
import de.justsoftware.mobile.gateway.settings.model.PlatformInfo;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.User;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsInfo;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsSettings;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsUser;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "", "newsApiGatewayService", "Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "peopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "getUser", "Lde/justsoftware/mobile/gateway/settings/model/User;", "getPlatformInfo", "Lde/justsoftware/mobile/gateway/settings/model/PlatformInfo;", "mobileAppsInfo", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsInfo;", "newsConfig", "Lde/justsoftware/mobile/gateway/news/model/NewsConfig;", "mobileAppsSettings", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsSettings;", "birthdayListEnabled", "", "mobile-gateway"})
public class SettingsService {
    @NotNull
    private final NewsApiGatewayService newsApiGatewayService;
    @NotNull
    private final PeopleApiGatewayService peopleApiGatewayService;
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;

    public SettingsService(@NotNull NewsApiGatewayService newsApiGatewayService, @NotNull PeopleApiGatewayService peopleApiGatewayService, @NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)newsApiGatewayService, (String)"newsApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)peopleApiGatewayService, (String)"peopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.newsApiGatewayService = newsApiGatewayService;
        this.peopleApiGatewayService = peopleApiGatewayService;
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public PlatformSettings getPlatformSettings() {
        return (PlatformSettings)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public User getUser() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return this.getUser(mobileAppsInfo);
    }

    @NotNull
    public PlatformInfo getPlatformInfo() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return new PlatformInfo(this.getUser(mobileAppsInfo), this.getPlatformSettings(mobileAppsInfo));
    }

    private PlatformSettings getPlatformSettings(ApiMobileAppsInfo mobileAppsInfo) {
        return (PlatformSettings)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private PlatformSettings getPlatformSettings(NewsConfig newsConfig, ApiMobileAppsSettings mobileAppsSettings, boolean birthdayListEnabled) {
        boolean bl = mobileAppsSettings.getTrackingEnabled();
        int n = newsConfig.getCommentMaxLength();
        boolean bl2 = newsConfig.getCommentsDisabledDefault();
        boolean bl3 = mobileAppsSettings.getChatEnabled();
        boolean bl4 = mobileAppsSettings.getNewsEnabled();
        boolean bl5 = mobileAppsSettings.getDeviceLockRequired();
        boolean bl6 = mobileAppsSettings.getCookieBannerEnabled();
        boolean bl7 = mobileAppsSettings.getChangeEmailEnabled();
        boolean bl8 = mobileAppsSettings.getChangePasswordEnabled();
        String string = mobileAppsSettings.getPlatformVersion();
        String string2 = mobileAppsSettings.getTermsPath();
        return new PlatformSettings(bl3, bl4, bl5, bl6, bl7, bl8, string, string2, birthdayListEnabled, bl, n, bl2, false, 4096, null);
    }

    private User getUser(ApiMobileAppsInfo mobileAppsInfo) {
        ApiMobileAppsUser mobileAppsUser = mobileAppsInfo.getUser();
        return new User(mobileAppsUser.getProfileId(), mobileAppsUser.getName(), mobileAppsUser.getFirstName(), mobileAppsUser.getLastName(), mobileAppsUser.getEmail(), mobileAppsUser.getImageId(), mobileAppsUser.getBirthday(), mobileAppsUser.getTermsAcceptanceRequired(), mobileAppsUser.getPreferredTranslationLanguage());
    }

    public static final /* synthetic */ ToroApiGatewayService access$getToroApiGatewayService$p(SettingsService $this) {
        return $this.toroApiGatewayService;
    }

    public static final /* synthetic */ NewsApiGatewayService access$getNewsApiGatewayService$p(SettingsService $this) {
        return $this.newsApiGatewayService;
    }

    public static final /* synthetic */ PeopleApiGatewayService access$getPeopleApiGatewayService$p(SettingsService $this) {
        return $this.peopleApiGatewayService;
    }

    public static final /* synthetic */ PlatformSettings access$getPlatformSettings(SettingsService $this, NewsConfig newsConfig, ApiMobileAppsSettings mobileAppsSettings, boolean birthdayListEnabled) {
        return $this.getPlatformSettings(newsConfig, mobileAppsSettings, birthdayListEnabled);
    }
}

