/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.UserResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class PatchRequestUtils {
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(PatchRequestUtils.class);

    @Nonnull
    public static UserResource patchUser(UserResource user, PatchRequest patch) throws ScimException, JsonProcessingException {
        PatchRequest fixedPatch = PatchRequestUtils.fixPatchRequest((PatchRequest)patch);
        GenericScimResource genericResource = user.asGenericScimResource();
        fixedPatch.apply(genericResource);
        return (UserResource)MAPPER.readValue(genericResource.getObjectNode().toString(), UserResource.class);
    }

    @Nonnull
    private static PatchRequest fixPatchRequest(PatchRequest request) {
        ArrayList fixedOperations = new ArrayList();
        List originalOperations = request.getOperations();
        originalOperations.forEach(operation -> {
            if (operation.getPath() != null) {
                fixedOperations.add(operation);
                return;
            }
            try {
                HashMap values = (HashMap)operation.getValue(HashMap.class);
                values.forEach((key, value) -> {
                    PatchOperation fixedOp = PatchRequestUtils.fixOperation((PatchOpType)operation.getOpType(), (String)key, (Object)value);
                    if (fixedOp != null) {
                        fixedOperations.add(fixedOp);
                    }
                });
            }
            catch (JsonProcessingException | ScimException e) {
                throw new IllegalStateException(String.format("Received incompatible PatchOperation: %s", operation));
            }
        });
        return new PatchRequest(fixedOperations);
    }

    @CheckForNull
    private static PatchOperation fixOperation(PatchOpType opType, String key, Object value) {
        try {
            HashMap<String, Object> patchOperation = new HashMap<String, Object>();
            patchOperation.put("op", opType);
            patchOperation.put("path", Path.fromString((String)key));
            patchOperation.put("value", value);
            JsonNode jsonNode = MAPPER.valueToTree(patchOperation);
            return (PatchOperation)MAPPER.treeToValue((TreeNode)jsonNode, PatchOperation.class);
        }
        catch (JsonProcessingException | BadRequestException e) {
            LOG.error("Could not fix operation", e);
            return null;
        }
    }
}

