/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.common;

import com.fasterxml.jackson.annotation.JsonValue;
import de.justsoftware.justimport.domain.model.common.ItemType;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractId<T> {
    private final T _id;
    private final ItemType _type;
    private final int _hash;
    private final Object[] _hashObjects;

    AbstractId(T id, ItemType type) {
        this._id = id;
        this._type = type;
        this._hashObjects = new Object[]{id, type};
        this._hash = Arrays.hashCode(this._hashObjects);
    }

    @Nonnull
    public final T getId() {
        return (T)this._id;
    }

    @Nonnull
    public ItemType getType() {
        return this._type;
    }

    public final int hashCode() {
        return this._hash;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof AbstractId && Arrays.equals(this._hashObjects, ((AbstractId)obj)._hashObjects);
    }

    @Nonnull
    private String idToString() {
        return this._id.toString();
    }

    @JsonValue
    public final String toString() {
        return this._type + "," + this.idToString();
    }

    @Nonnull
    public final String asString() {
        return this.toString();
    }

    @CheckForNull
    public static Long longId(@Nullable AbstractId<?> id) {
        return id == null ? null : Long.valueOf(Long.parseLong(id.getId().toString()));
    }
}

