/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.kafka.JustPersonDto;
import de.justsoftware.gateway.util.ObjectUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.PartitionOffset;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedCaseInsensitiveMap;

@Service
@ParametersAreNonnullByDefault
public class EmailToProfileMapper {
    private static final String JUST_PERSONS_TOPIC = "just.persons";
    private final Map<String, ProfileId> _emailToProfileIdMap = new LinkedCaseInsensitiveMap();
    private final Set<ProfileId> _activePersons = ConcurrentHashMap.newKeySet();

    @KafkaListener(topics={"just.persons"}, containerFactory="justPersonsContainerFactory", topicPartitions={@TopicPartition(topic="just.persons", partitions={"0"}, partitionOffsets={@PartitionOffset(partition="*", initialOffset="0")})})
    public void listenForJustPersons(@Header(value="kafka_receivedMessageKey") ProfileId internalId, @Payload(required=false) @Nullable JustPersonDto personDto) {
        boolean canLogin;
        this.removeMapping(internalId);
        boolean bl = canLogin = personDto != null && personDto.isActive() && !personDto.isBlocked();
        if (canLogin && personDto.getEmail() != null) {
            ProfileId currentMapping = this.findByEmail((String)ObjectUtil.checkNotNull((Object)personDto.getEmail()));
            if (currentMapping != null) {
                this.removeMapping(currentMapping);
            }
            this.addMapping((String)ObjectUtil.checkNotNull((Object)personDto.getEmail()), personDto.getProfileId());
        }
        if (canLogin) {
            this._activePersons.add(internalId);
        } else {
            this._activePersons.remove(internalId);
        }
    }

    @VisibleForTesting
    void addMapping(String email, ProfileId profileId) {
        this._emailToProfileIdMap.put(email, profileId);
    }

    private void removeMapping(ProfileId profileId) {
        this._emailToProfileIdMap.values().removeAll(Set.of(profileId));
    }

    @CheckForNull
    public ProfileId findByEmail(String email) {
        return (ProfileId)this._emailToProfileIdMap.get(email);
    }

    public boolean mayLogin(ProfileId profileId) {
        return this._activePersons.contains(profileId);
    }
}

