/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka.tracking;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.justsoftware.gateway.domain.tracking.TrackingSettingsService;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.kafka.tracking.TrackingValue;
import java.net.URI;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

@ParametersAreNonnullByDefault
@Service
public class MobileTrackingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MobileTrackingConsumer.class);
    private final TrackingSettingsService _trackingSettingsService;
    private final HttpClient _matomoHttpClient;
    private final LoadingCache<String, WebClient> _webclientCache;

    public MobileTrackingConsumer(TrackingSettingsService trackingSettingsService) {
        this._trackingSettingsService = trackingSettingsService;
        this._matomoHttpClient = this.initWebclient();
        this._webclientCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).build(arg_0 -> this.getWebClientForBaseUrl(arg_0));
    }

    @Nonnull
    private HttpClient initWebclient() {
        ConnectionProvider fixedPool = ((ConnectionProvider.Builder)ConnectionProvider.builder((String)"matomoTrackingPool").maxConnections(10)).build();
        return HttpClient.create((ConnectionProvider)fixedPool);
    }

    @KafkaListener(topics={"tracking"}, containerFactory="mobileTrackingListenerContainerFactory")
    public void listen(@Payload TrackingValue message) {
        if (!"PAGE_VIEW".equals(message.getTarget().get("type")) || !"mobile-social".equals(message.getTarget().get("client")) || message.getTenantId() == null) {
            LOG.debug("not from mobile: {}", (Object)message);
            return;
        }
        TenantId tenantId = message.getTenantId();
        this._trackingSettingsService.findSettings(tenantId).doOnSuccess(trackingSettings -> {
            String matomoUrl = trackingSettings.getMatomoUrl();
            String matomoSiteId = trackingSettings.getMatomoSiteId();
            String matomoAuthToken = trackingSettings.getMatomoAuthToken();
            if (matomoSiteId == null || matomoUrl == null || matomoAuthToken == null) {
                return;
            }
            WebClient client = (WebClient)this._webclientCache.get((Object)matomoUrl);
            client.get().uri(builder -> this.createTrackingUri(builder, matomoSiteId, matomoAuthToken, message)).retrieve().toBodilessEntity().doOnError(e -> LOG.error(e.getMessage(), e)).subscribe();
        }).subscribe();
    }

    @Nonnull
    private WebClient getWebClientForBaseUrl(String matomoUrl) {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(this._matomoHttpClient)).filters(filterFunctions -> filterFunctions.add(ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("calling matomo: {}", (Object)clientRequest.url());
            }
            return Mono.just((Object)clientRequest);
        }))).baseUrl(matomoUrl + "/matomo.php").build();
    }

    @Nonnull
    protected URI createTrackingUri(UriBuilder builder, String matomoSiteId, String matomoAuthToken, TrackingValue message) {
        return builder.queryParam("idsite", new Object[]{matomoSiteId}).queryParam("token_auth", new Object[]{matomoAuthToken}).queryParam("uid", new Object[]{message.getTarget().get("holmesId")}).queryParam("rec", new Object[]{"1"}).queryParam("apiv", new Object[]{"1"}).queryParam("url", new Object[]{message.getReferer()}).queryParam("ua", new Object[]{message.getUserAgent()}).queryParam("action_name", new Object[]{"Page impressions in mobile app Just Social"}).queryParam("cip", new Object[]{message.getIpAddress()}).queryParam("cdt", new Object[]{message.getTimestamp()}).build(new Object[0]);
    }
}

