/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.fasterxml.jackson.annotation.JsonTypeName;
import de.justsoftware.drive.common.document.model.MicroblogEntryId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.rest.models.DocumentListEntry;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@JsonTypeName(value="MICROBLOG")
@Schema(description="Model for a link to microblog attachments in a document list")
public class MicroblogEntry
implements DocumentListEntry {
    private final MicroblogEntryId _microblogEntryId;
    private final ItemId _rootItemId;

    public MicroblogEntry(ItemId rootItemId) {
        this._rootItemId = rootItemId;
        this._microblogEntryId = new MicroblogEntryId(rootItemId);
    }

    @Schema(required=true)
    @Nonnull
    public ItemId getRootItemId() {
        return this._rootItemId;
    }

    @Schema(required=true)
    @Nonnull
    public MicroblogEntryId getVersionId() {
        return this._microblogEntryId;
    }
}

