/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.shares.ShareNotificationPublisher;
import de.justsoftware.drive.business.shares.UpdateType;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ShareNotificationPublisherImpl
implements ShareNotificationPublisher {
    private static final Joiner MEMBER_KEY_JOINER = Joiner.on((char)';');
    private static final String SHARE_DATA_TOPIC = "just.drive.shares";
    private static final String SHARE_MEMBER_TOPIC = "just.drive.shares.members";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(ShareNotificationPublisherImpl.class);
    private final Producer<String, String> _kafkaProducer;

    @Autowired
    public ShareNotificationPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish share to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public void publishDeletedShare(ItemId shareId, ImmutableSet<PersonId> deletedMembers) {
        if (this._kafkaProducer == null) {
            return;
        }
        ProducerRecord record = new ProducerRecord(SHARE_DATA_TOPIC, (Object)((String)shareId.getId()), null);
        this._kafkaProducer.send(record, (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
        this.publishDeletedMembers(shareId, deletedMembers);
    }

    private void publishDeletedMembers(ItemId shareId, ImmutableSet<PersonId> deletedMembers) {
        if (this._kafkaProducer == null) {
            return;
        }
        for (PersonId member : deletedMembers) {
            ProducerRecord record = new ProducerRecord(SHARE_MEMBER_TOPIC, (Object)this.createKey(shareId, member), null);
            this._kafkaProducer.send(record, (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
        }
    }

    @Nonnull
    private String createKey(ItemId shareId, PersonId member) {
        return MEMBER_KEY_JOINER.join(shareId.getId(), (Object)Long.toString(member.getId()), new Object[0]);
    }

    public void publishMemberChanges(ItemId shareId, PersonId executor, String name, UpdateType updateType, DocumentId rootFolderId, ImmutableSet<PersonId> addedMembers, ImmutableSet<PersonId> deletedMembers) {
        if (this._kafkaProducer == null) {
            return;
        }
        for (PersonId member : addedMembers) {
            try {
                ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
                jsonNode.set("executor", (JsonNode)TextNode.valueOf((String)String.valueOf(executor.getId())));
                jsonNode.set("name", (JsonNode)TextNode.valueOf((String)name));
                jsonNode.set("type", (JsonNode)TextNode.valueOf((String)updateType.name()));
                jsonNode.set("rootFolderId", (JsonNode)TextNode.valueOf((String)((UUID)rootFolderId.getId()).toString()));
                ProducerRecord record = new ProducerRecord(SHARE_MEMBER_TOPIC, (Object)this.createKey(shareId, member), (Object)OBJECT_MAPPER.writeValueAsString((Object)jsonNode));
                this._kafkaProducer.send(record, (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
            }
            catch (JsonProcessingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        this.publishDeletedMembers(shareId, deletedMembers);
    }
}

