/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.drive.business.authorization.ItemReadRoleService;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.event.DocumentPublicityUpdated;
import de.justsoftware.drive.business.event.DocumentTreeRestoredEvent;
import de.justsoftware.drive.business.event.DocumentsChangedEvent;
import de.justsoftware.drive.business.event.DocumentsMovedEvent;
import de.justsoftware.drive.business.event.FilesCreatedEvent;
import de.justsoftware.drive.business.event.FilesDeletedEvent;
import de.justsoftware.drive.business.event.FilesRenamedEvent;
import de.justsoftware.drive.business.event.FoldersCreatedEvent;
import de.justsoftware.drive.business.event.FoldersDeletedEvent;
import de.justsoftware.drive.business.event.FoldersRenamedEvent;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.event.NewFileVersionUploadedEvent;
import de.justsoftware.drive.business.event.PersonRolesChangedEvent;
import de.justsoftware.drive.business.event.PersonUpdatedEvent;
import de.justsoftware.drive.business.search.SearchIndexQueueProducer;
import de.justsoftware.drive.common.authorization.model.ItemRole;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchableId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class SearchIndexQueueProducer {
    private final SearchIndexQueueDAO _searchIndexQueueDAO;
    private final DocumentSupportDAO _documentSupportDAO;
    private final DocumentService _documentService;
    private final ItemReadRoleService _itemReadRoleService;
    private final ItemDAO _itemDAO;
    private final SolrIndexQueue _solrIndexQueue;

    @Autowired
    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="would need refactoring")
    public SearchIndexQueueProducer(SearchIndexQueueDAO searchIndexQueueDAO, DocumentSupportDAO documentSupportDAO, DocumentService documentService, ItemReadRoleService itemReadRoleService, EventBus eventBus, ItemDAO itemDAO, SolrIndexQueue solrIndexQueue) {
        this._searchIndexQueueDAO = searchIndexQueueDAO;
        this._documentSupportDAO = documentSupportDAO;
        this._documentService = documentService;
        this._itemReadRoleService = itemReadRoleService;
        this._itemDAO = itemDAO;
        this._solrIndexQueue = solrIndexQueue;
        eventBus.register((Object)this);
    }

    private void handle(Set<DocumentId> documents, SearchIndexType indexType) {
        this._searchIndexQueueDAO.insert((Iterable)FluentIterable.from(documents).transform((Function)new CreateIndexQueueEntryFunction(this, indexType)).toList());
        this.addToSolrIndexQueue(documents, indexType);
    }

    private void handle(DocumentsChangedEvent e, SearchIndexType indexType) {
        this.handle((Set)e.getDocumentVersions().keySet(), indexType);
    }

    private void handleItems(ImmutableSet<ItemId> items, SearchIndexType indexType) {
        this._searchIndexQueueDAO.insertAllDocumentsOfItems(items, indexType);
    }

    private void handleItemsAndDependentItems(ImmutableSet<ItemId> parentItems, SearchIndexType indexType) {
        ImmutableCollection dependentItems = this._itemDAO.getChildren(parentItems).values();
        this.handleItems(FluentIterable.from(parentItems).append((Iterable)dependentItems).toSet(), indexType);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesCreated(FilesCreatedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.ALL);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersCreated(FoldersCreatedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.ALL);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesRenamed(FilesRenamedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersRenamed(FoldersRenamedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesDeleted(FilesDeletedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.DELETE);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersDeleted(FoldersDeletedEvent e) {
        this.handleRecursive((DocumentsChangedEvent)e, SearchIndexType.DELETE);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMetadataChanged(DocumentMetadataChangedEvent e) {
        this.handle((Set)e.getDocumentIds(), SearchIndexType.METADATA);
    }

    private void handleRecursive(DocumentsChangedEvent e, SearchIndexType indexType) {
        this.handle((Set)Sets.union((Set)e.getDocumentVersions().keySet(), (Set)this.getAllChildren(e)), indexType);
    }

    @Nonnull
    private ImmutableSet<DocumentId> getAllChildren(DocumentsChangedEvent e) {
        ImmutableMap documentVersions = e.getDocumentVersions();
        ImmutableSetMultimap children = this._documentSupportDAO.getFolderContentsRecursive((Set)ImmutableSet.copyOf((Collection)documentVersions.values()));
        ImmutableMap documentIdsOfChildren = this._documentService.getDocumentIdsOfVersions((Set)children.inverse().keySet());
        return ImmutableSet.copyOf((Collection)documentIdsOfChildren.values());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onItemVisiblitiesChanged(ItemVisibilitiesChangedEvent e) {
        this.handleItemsAndDependentItems(e.getItems(), SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentTreeRestored(DocumentTreeRestoredEvent e) {
        this.handleItems(ImmutableSet.of((Object)e.getItemId()), SearchIndexType.ALL);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonRolesChanged(PersonRolesChangedEvent e) {
        ImmutableSet changedRoles = FluentIterable.from((Iterable)e.getRolesToRemove().values()).append((Iterable)e.getRolesToAdd().values()).filter(ItemRole.class).toSet();
        this.handleItemsAndDependentItems(this._itemReadRoleService.getItemsWithReadRoles((Set)changedRoles).inverse().keySet(), SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonUpdated(PersonUpdatedEvent e) {
        this._searchIndexQueueDAO.insertAllDocumentsOfOwner((Set)e.getPersonIds(), SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewFileVersionUploaded(NewFileVersionUploadedEvent e) {
        this.handle((DocumentsChangedEvent)e, SearchIndexType.ALL);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentsMoved(DocumentsMovedEvent e) {
        this.handleRecursive((DocumentsChangedEvent)e, SearchIndexType.METADATA);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentPublicityUpdated(DocumentPublicityUpdated e) {
        this.handleRecursive((DocumentsChangedEvent)e, SearchIndexType.ALL);
        this.handleItems(e.getExpirationDateUpdates(), SearchIndexType.EXPIRATION_DATE);
    }

    public void onItemPurged(Set<ItemId> items) {
        this.handleItems(ImmutableSet.copyOf(items), SearchIndexType.DELETE);
    }

    private void addToSolrIndexQueue(Set<DocumentId> documents, SearchIndexType indexType) {
        switch (1.$SwitchMap$de$justsoftware$drive$persistence$search$model$SearchIndexType[indexType.ordinal()]) {
            case 1: 
            case 2: {
                this._solrIndexQueue.queueFullIndex(SearchIndexQueueProducer.toSearchableIds(documents));
                break;
            }
            case 3: 
            case 4: {
                this._solrIndexQueue.queueMetadataAtomicUpdate(SearchIndexQueueProducer.toSearchableIds(documents));
            }
        }
    }

    @Nonnull
    private static List<SearchableId> toSearchableIds(Collection<DocumentId> documentIds) {
        return documentIds.stream().map(SearchIndexQueueProducer::toSearchableId).collect(Collectors.toList());
    }

    @Nonnull
    private static SearchableId toSearchableId(DocumentId documentId) {
        return SearchableId.Companion.fromCanonicalId(documentId.toSearchId());
    }
}

