/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.search.DocumentSearchException;
import de.justsoftware.drive.business.search.DocumentSearchResultBO;
import de.justsoftware.drive.business.search.DocumentSearchResultEntryBO;
import de.justsoftware.drive.business.search.DocumentSearchService;
import de.justsoftware.drive.business.search.DriveSearchParameters;
import de.justsoftware.drive.business.search.DriveSolrSearchField;
import de.justsoftware.drive.business.search.SearchAuthorizationContext;
import de.justsoftware.drive.business.search.SearchSortParams;
import de.justsoftware.drive.business.search.SolrQueryBuilder;
import de.justsoftware.drive.business.search.SolrResultDocument;
import de.justsoftware.drive.business.search.SolrResultDocumentBean;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentSearchServiceImpl
implements DocumentSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentSearchServiceImpl.class);
    private static final String DRIVE_SEARCH_QUERY_HANDLER = "driveSearch";
    private final SolrClient _solrClient;
    private final SearchIndexQueueDAO _searchIndexQueueDAO;
    private final FolderService _folderService;
    private final FileService _fileService;
    private final SolrIndexQueue _solrIndexQueue;

    @Autowired
    public DocumentSearchServiceImpl(@Qualifier(value="readSolrClient") SolrClient solrClient, FolderService folderService, FileService fileService, SearchIndexQueueDAO searchIndexQueueDAO, SolrIndexQueue solrIndexQueue) {
        this._solrClient = solrClient;
        this._folderService = folderService;
        this._fileService = fileService;
        this._searchIndexQueueDAO = searchIndexQueueDAO;
        this._solrIndexQueue = solrIndexQueue;
    }

    public DocumentSearchResultBO search(SearchAuthorizationContext authCtx, DriveSearchParameters searchParameters) throws DocumentSearchException {
        SolrQuery query = new SolrQuery(searchParameters._searchText.isEmpty() ? "*" : searchParameters._searchText);
        query.setRequestHandler(DRIVE_SEARCH_QUERY_HANDLER);
        if (searchParameters._limit.isPresent()) {
            query.setRows((Integer)searchParameters._limit.get());
        }
        if (searchParameters._offset.isPresent()) {
            query.setStart((Integer)searchParameters._offset.get());
        }
        if (searchParameters._sortParams.isPresent()) {
            query.setSort(SolrQueryBuilder.toSolrSortClause((SearchSortParams)((SearchSortParams)searchParameters._sortParams.get())));
        }
        query.setFilterQueries((String[])Iterables.toArray((Iterable)this.getFilterQueries(authCtx, searchParameters), String.class));
        try {
            QueryResponse response = this._solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
            ImmutableList entries = ImmutableList.copyOf((Collection)response.getBeans(SolrResultDocumentBean.class));
            return new DocumentSearchResultBO(this.transformResultEntries((List)entries), response.getResults().getNumFound());
        }
        catch (IOException | SolrServerException e) {
            throw new DocumentSearchException("Failed to execute search query", e);
        }
    }

    @Nonnull
    private ImmutableList<DocumentSearchResultEntryBO> transformResultEntries(List<SolrResultDocument> entries) {
        ImmutableSet documents = FluentIterable.from(entries).transform(SolrResultDocument::getId).toSet();
        ImmutableMap currentPublic = this._folderService.getCurrentVersionsOfDocuments((Set)documents, PublishedFilter.ONLY_PUBLISHED);
        Predicate isCurrentPublic = entry -> Objects.equal((Object)entry.getDocumentVersionId(), (Object)currentPublic.get((Object)entry.getId()));
        ImmutableMap currentPrivate = this._folderService.getCurrentVersionsOfDocuments((Set)FluentIterable.from(entries).filter(Predicates.not((Predicate)isCurrentPublic)).transform(SolrResultDocument::getId).toSet(), PublishedFilter.PUBLISHED_OR_PRIVATE);
        ImmutableSet ids = FluentIterable.from(entries).transform(SolrResultDocument::getDocumentVersionId).append((Iterable)currentPrivate.values()).append((Iterable)currentPublic.values()).toSet();
        HashMap existingDocumentVersions = new HashMap(ids.size());
        existingDocumentVersions.putAll(this._fileService.getVersionsByIds((Set)ids));
        existingDocumentVersions.putAll(this._folderService.getFolderVersionsByIds((Set)ids));
        return FluentIterable.from(entries).transform(input -> {
            DocumentVersionBO current;
            DocumentVersionBO documentVersionBO = (DocumentVersionBO)existingDocumentVersions.get(input.getDocumentVersionId());
            if (isCurrentPublic.apply(input)) {
                current = documentVersionBO;
            } else {
                ImmutableMap m = documentVersionBO == null || documentVersionBO.isPublic() ? currentPublic : currentPrivate;
                current = (DocumentVersionBO)existingDocumentVersions.get(m.get((Object)input.getId()));
            }
            return current != null ? new DocumentSearchResultEntryBO(current, input.getParentFolderIds()) : null;
        }).filter(Predicates.notNull()).toList();
    }

    @Nonnull
    private ImmutableList<String> getFilterQueries(SearchAuthorizationContext authCtx, DriveSearchParameters sp) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (sp._searchInFolder.isPresent()) {
            result.add((Object)SolrQueryBuilder.getFilterQuery((DriveSolrSearchField)DriveSolrSearchField.PARENT_FOLDER_ID, (String)((UUID)((DocumentId)sp._searchInFolder.get()).getId()).toString()));
        }
        if (sp._parentItemType.isPresent()) {
            result.add((Object)SolrQueryBuilder.getFilterQuery((DriveSolrSearchField)DriveSolrSearchField.PARENT_ITEM_TYPE, (String)((ItemType)sp._parentItemType.get()).name()));
        }
        if (sp._grandmaItemId.isPresent()) {
            result.add((Object)SolrQueryBuilder.getFilterQuery((DriveSolrSearchField)DriveSolrSearchField.GRANDMA_ITEM_ID, (String)((String)((ItemId)sp._grandmaItemId.get()).getId())));
        }
        result.add((Object)SolrQueryBuilder.getFilterQuery((DriveSolrSearchField)DriveSolrSearchField.JUST_APP_ID, (String)"DRIVE"));
        result.add((Object)SolrQueryBuilder.orFilterQuery((DriveSolrSearchField)DriveSolrSearchField.VISIBLE_FOR_ROLES, (Set)((Set)authCtx.getSearchRoles().stream().map(Role::asString).collect(ImmutableSet.toImmutableSet()))));
        return result.build();
    }

    public void reindexAllDocuments() {
        try {
            this._solrClient.deleteByQuery(SolrQueryBuilder.getFilterQuery((DriveSolrSearchField)DriveSolrSearchField.JUST_APP_ID, (String)"DRIVE"));
        }
        catch (IOException | SolrServerException e) {
            LOG.error("existing drive documents could not be deleted from solr", e);
        }
        finally {
            this._searchIndexQueueDAO.insertAllDocuments(SearchIndexType.ALL);
        }
        this._solrIndexQueue.reindex((Set)ImmutableSet.of((Object)SearchType.DOCUMENT), null);
    }
}

