/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.search.ChatCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.kafka.search.CommonCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.CommonCoreSearchFields;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.SearchId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.KafkaUtilsKt;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 R2\u00020\u0001:\u0002RSBY\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0012J\u0016\u0010&\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$H\u0012J\b\u0010)\u001a\u00020*H\u0012J\"\u0010+\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/H\u0012JH\u00100\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u0002010$0,2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020-0,2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u0002040$0,H\u0012J\"\u00105\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070,2\f\u00108\u001a\b\u0012\u0004\u0012\u0002060/H\u0012J!\u00109\u001a\u00020\"2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0;H\u0011\u00a2\u0006\u0002\b=J!\u0010>\u001a\u00020\"2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0;H\u0011\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020\"H\u0016J\b\u0010A\u001a\u00020\"H\u0016J\b\u0010B\u001a\u00020\"H\u0016J\b\u0010C\u001a\u00020\"H\u0016J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020E0$2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002070GH\u0012J\u001a\u0010H\u001a\u00020\"*\u00020\u00192\f\u0010I\u001a\b\u0012\u0004\u0012\u00020E0$H\u0012J\u001a\u0010J\u001a\u00020\"*\u00020\u00192\f\u0010I\u001a\b\u0012\u0004\u0012\u00020E0$H\u0012J\u001a\u0010K\u001a\u00020\"*\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/H\u0012J\u001a\u0010L\u001a\u00020\"*\u00020\u00192\f\u0010M\u001a\b\u0012\u0004\u0012\u00020<0$H\u0012J\u001a\u0010N\u001a\u00020\"*\u00020\u00192\f\u0010M\u001a\b\u0012\u0004\u0012\u00020<0$H\u0012J\u001a\u0010O\u001a\u0004\u0018\u00010(*\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0PH\u0012J\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00020%0$*\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0PH\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u00020\u00198\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u00020\u00198\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001b\u001a\u0004\b \u0010\u001dR\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lde/justsoftware/chat/search/SolrIndexService;", "", "commonCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "chatCoreLeaderSolrClient", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "commonCoreSearchUpdateIndexProducer", "Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;", "chatCoreSearchUpdateIndexProducer", "Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/apache/solr/client/solrj/SolrClient;Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;Lde/justsoftware/search/shared/SolrIndexQueue;Lio/micrometer/core/instrument/MeterRegistry;)V", "chatCoreReindexThread", "Ljava/lang/Thread;", "chatSolrCore", "Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "getChatSolrCore$chat_service$annotations", "()V", "getChatSolrCore$chat_service", "()Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "commonSolrCore", "getCommonSolrCore$chat_service$annotations", "getCommonSolrCore$chat_service", "indexChatCore", "", "searchIds", "", "Lde/justsoftware/chat/model/SearchId;", "indexChatInCommonCore", "chatIdsToIndex", "Lde/justsoftware/chat/model/ChatId;", "isReindexingChatCore", "", "loadChats", "", "Lde/justsoftware/chat/business/model/Chat;", "chatIds", "", "loadOneOnOneChatPartners", "Lde/justsoftware/chat/business/model/Profile;", "chats", "chatParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "loadUserMessages", "Lde/justsoftware/chat/model/ChatMessageId;", "Lde/justsoftware/chat/business/model/UserMessage;", "chatMessageIds", "onIndexChatCore", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "onIndexChatCore$chat_service", "onIndexCommonCore", "onIndexCommonCore$chat_service", "reindexAll", "reindexChatCore", "reindexChatsInCommonCore", "reindexJustSocialCore", "toSolrInputDocuments", "Lorg/apache/solr/common/SolrInputDocument;", "userMessages", "", "addSolrDocuments", "documents", "addSolrDocumentsIndividually", "deleteByChatIds", "deleteSolrDocuments", "ids", "deleteSolrDocumentsIndividually", "getChatId", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "toSearchIds", "Companion", "SolrCore", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSolrIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ChatParticipant.kt\nde/justsoftware/chat/business/model/ChatParticipant$Companion\n+ 7 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 8 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,437:1\n1603#2,9:438\n1855#2:447\n1856#2:449\n1612#2:450\n1603#2,9:451\n1855#2:460\n1856#2:462\n1612#2:463\n1549#2:464\n1620#2,3:465\n1549#2:468\n1620#2,3:469\n809#2,2:473\n809#2,2:476\n1549#2:478\n1620#2,3:479\n1549#2:482\n1620#2,3:483\n1549#2:486\n1620#2,3:487\n1549#2:490\n1620#2,3:491\n1603#2,9:496\n1855#2:505\n1856#2:507\n1612#2:508\n1179#2,2:510\n1253#2,4:512\n800#2,11:523\n1620#2,3:535\n1603#2,9:538\n1855#2:547\n1856#2:549\n1612#2:550\n1549#2:552\n1620#2,3:553\n809#2,2:558\n1271#2,2:560\n1285#2,2:562\n1603#2,9:564\n1855#2:573\n1856#2:575\n1612#2:576\n1288#2:577\n1855#2,2:578\n1549#2:580\n1620#2,3:581\n1855#2,2:584\n1855#2,2:586\n1#3:448\n1#3:461\n1#3:506\n1#3:548\n1#3:574\n22#4:472\n22#4:475\n80#4,2:494\n82#4:509\n7#4:534\n22#4:557\n526#5:516\n511#5,6:517\n41#6:551\n42#6:556\n58#7:588\n51#7:589\n9#8:590\n8#8,3:591\n*S KotlinDebug\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n*L\n151#1:438,9\n151#1:447\n151#1:449\n151#1:450\n164#1:451,9\n164#1:460\n164#1:462\n164#1:463\n175#1:464\n175#1:465,3\n178#1:468\n178#1:469,3\n191#1:473,2\n192#1:476,2\n201#1:478\n201#1:479,3\n211#1:482\n211#1:483,3\n211#1:486\n211#1:487,3\n227#1:490\n227#1:491,3\n231#1:496,9\n231#1:505\n231#1:507\n231#1:508\n231#1:510,2\n231#1:512,4\n245#1:523,11\n246#1:535,3\n248#1:538,9\n248#1:547\n248#1:549\n248#1:550\n250#1:552\n250#1:553,3\n250#1:558,2\n252#1:560,2\n252#1:562,2\n255#1:564,9\n255#1:573\n255#1:575\n255#1:576\n252#1:577\n275#1:578,2\n304#1:580\n304#1:581,3\n306#1:584,2\n321#1:586,2\n151#1:448\n164#1:461\n231#1:506\n248#1:548\n255#1:574\n191#1:472\n192#1:475\n231#1:494,2\n231#1:509\n246#1:534\n250#1:557\n236#1:516\n236#1:517,6\n250#1:551\n250#1:556\n347#1:588\n347#1:589\n357#1:590\n357#1:591,3\n*E\n"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient commonCoreLeaderSolrClient;
    @NotNull
    private final SolrClient chatCoreLeaderSolrClient;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final CommonCoreSearchUpdateIndexProducer commonCoreSearchUpdateIndexProducer;
    @NotNull
    private final ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    private final SolrCore commonSolrCore;
    @NotNull
    private final SolrCore chatSolrCore;
    @Nullable
    private Thread chatCoreReindexThread;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CHAT_APP_ID = "CHAT";

    public SolrIndexService(@Qualifier(value="commonCoreLeaderSolrClient") @NotNull SolrClient commonCoreLeaderSolrClient, @Qualifier(value="chatCoreLeaderSolrClient") @NotNull SolrClient chatCoreLeaderSolrClient, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService, @NotNull ProfileService profileService, @NotNull CommonCoreSearchUpdateIndexProducer commonCoreSearchUpdateIndexProducer, @NotNull ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer, @NotNull SolrIndexQueue solrIndexQueue, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)commonCoreLeaderSolrClient, (String)"commonCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatCoreLeaderSolrClient, (String)"chatCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)commonCoreSearchUpdateIndexProducer, (String)"commonCoreSearchUpdateIndexProducer");
        Intrinsics.checkNotNullParameter((Object)chatCoreSearchUpdateIndexProducer, (String)"chatCoreSearchUpdateIndexProducer");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.commonCoreLeaderSolrClient = commonCoreLeaderSolrClient;
        this.chatCoreLeaderSolrClient = chatCoreLeaderSolrClient;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
        this.profileService = profileService;
        this.commonCoreSearchUpdateIndexProducer = commonCoreSearchUpdateIndexProducer;
        this.chatCoreSearchUpdateIndexProducer = chatCoreSearchUpdateIndexProducer;
        this.solrIndexQueue = solrIndexQueue;
        this.commonSolrCore = new SolrCore("common", this.commonCoreLeaderSolrClient, meterRegistry);
        this.chatSolrCore = new SolrCore("chat", this.chatCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getCommonSolrCore$chat_service() {
        return this.commonSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCommonSolrCore$chat_service$annotations() {
    }

    @NotNull
    public SolrCore getChatSolrCore$chat_service() {
        return this.chatSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getChatSolrCore$chat_service$annotations() {
    }

    public void reindexAll() {
        this.commonCoreLeaderSolrClient.deleteByQuery(CommonCoreSearchFields.INSTANCE + ".JUST_APP_ID:CHAT");
        this.reindexChatsInCommonCore();
        this.reindexChatCore();
        this.reindexJustSocialCore();
    }

    public void reindexJustSocialCore() {
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)SearchType.CHAT), null, (int)2, null);
    }

    public void reindexChatsInCommonCore() {
        LOG.info("Start reindexing chats in common core...");
        this.commonCoreLeaderSolrClient.deleteByQuery("type:CHAT");
        LOG.info("Deleted all Solr documents of type CHAT in solr common core.");
        Ref.IntRef chatCount = new Ref.IntRef();
        CollectionUtilsKt.chunked((Stream)this.chatService.streamAllIds(), (int)1000).forEach(arg_0 -> SolrIndexService.reindexChatsInCommonCore$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        LOG.info("Filling common core index kafka topic finished...");
    }

    public void reindexChatCore() {
        if (this.isReindexingChatCore()) {
            LOG.info("Skip reindexing chat core, since a reindexing process is still alive...");
            return;
        }
        this.chatCoreReindexThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="commonCoreSearchUpdateIndexConsumer", containerFactory="commonCoreSearchUpdateIndexConsumerFactory", topics={"just.chat-service.search.common.updateIndex"}, idIsGroup=false)
    public void onIndexCommonCore$chat_service(@NotNull ConsumerRecords<String, String> records) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable iterable = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        SolrIndexService solrIndexService = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord it = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            if (this.getChatId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        solrIndexService.indexChatInCommonCore((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="chatCoreSearchUpdateIndexConsumer", containerFactory="chatCoreSearchUpdateIndexConsumerFactory", topics={"just.chat-service.search.chat.updateIndex"}, idIsGroup=false)
    public void onIndexChatCore$chat_service(@NotNull ConsumerRecords<String, String> records) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable iterable = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        SolrIndexService solrIndexService = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord it = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            if (this.toSearchIds(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        solrIndexService.indexChatCore(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private void indexChatInCommonCore(List<ChatId> chatIdsToIndex) {
        Chat p0;
        Collection<SolrInputDocument> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (chatIdsToIndex.isEmpty()) {
            return;
        }
        Map chats2 = this.loadChats(CollectionsKt.toSet((Iterable)chatIdsToIndex));
        Map chatParticipants = this.chatParticipantService.findByChatIds((Iterable)chats2.keySet());
        Map chatPartners = this.loadOneOnOneChatPartners(chats2, chatParticipants);
        List idsToDeleted = CollectionsKt.minus((Iterable)chatIdsToIndex, (Iterable)chats2.keySet());
        Iterable iterable = idsToDeleted;
        SolrCore solrCore = this.getCommonSolrCore$chat_service();
        SolrIndexService solrIndexService = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SolrInputDocument)p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        solrIndexService.deleteSolrDocuments(solrCore, (List)collection);
        $this$map$iv = chats2.values();
        solrCore = this.getCommonSolrCore$chat_service();
        solrIndexService = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chat;
            p0 = (Chat)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toCommonCoreSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())), (List)chatParticipants.getOrDefault(chat.getId(), CollectionsKt.emptyList())));
        }
        collection = (List)destination$iv$iv;
        solrIndexService.addSolrDocuments(solrCore, collection);
    }

    /*
     * WARNING - void declaration
     */
    private void indexChatCore(List<? extends SearchId> searchIds) {
        Collection<String> collection;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection3;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        if (searchIds.isEmpty()) {
            return;
        }
        Iterable $this$filterIsInstanceToSet$iv = searchIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ChatId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set chatIds2 = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = searchIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChatMessageId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set chatMessageIds = (Set)destination$iv$iv2;
        Map chats2 = this.chatService.findByIds(chatIds2);
        Map chatParticipants = this.chatParticipantService.findByChatIds((Iterable)chats2.keySet());
        Map chatPartners = this.loadOneOnOneChatPartners(chats2, chatParticipants);
        Set chatIdsToDeleted = SetsKt.minus((Set)chatIds2, (Iterable)chats2.keySet());
        Map userMessages = this.loadUserMessages(chatMessageIds);
        Set messageIdsToDeleted = SetsKt.minus((Set)chatMessageIds, (Iterable)userMessages.keySet());
        Iterable iterable2 = chats2.values();
        boolean $i$f$map22 = false;
        void var13_20 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void chat;
            Chat chat2 = (Chat)item$iv$iv;
            collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())), (List)chatParticipants.getOrDefault(chat.getId(), CollectionsKt.emptyList())));
        }
        List chatSolrInputDocs = (List)destination$iv$iv3;
        List messageSolrInputDocs = this.toSolrInputDocuments((Iterable)userMessages.values());
        Iterable $i$f$map22 = chatIdsToDeleted;
        SolrCore solrCore = this.getChatSolrCore$chat_service();
        collection3 = this;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId bl = (ChatId)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl2 = false;
            collection2.add(p0.toCanonicalId());
        }
        collection2 = (List)destination$iv$iv4;
        $this$map$iv = messageIdsToDeleted;
        collection2 = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatMessageId p0 = (ChatMessageId)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv4;
        super.deleteSolrDocuments(solrCore, CollectionsKt.plus(collection2, (Iterable)collection));
        this.deleteByChatIds(this.getChatSolrCore$chat_service(), chatIdsToDeleted);
        this.addSolrDocuments(this.getChatSolrCore$chat_service(), CollectionsKt.plus((Collection)chatSolrInputDocs, (Iterable)messageSolrInputDocs));
        LOG.debug("Index Summary: \nIndexed documents: " + (chatSolrInputDocs.size() + messageSolrInputDocs.size()) + "\nChats documents: " + chatSolrInputDocs.size() + "\nmessages documents: " + messageSolrInputDocs.size() + "\ndeleted documents: " + chatIdsToDeleted.size());
    }

    /*
     * WARNING - void declaration
     */
    private List<SolrInputDocument> toSolrInputDocuments(Iterable<UserMessage> userMessages) {
        void $this$mapTo$iv$iv;
        Iterable<UserMessage> $this$map$iv = userMessages;
        boolean $i$f$map = false;
        Iterable<UserMessage> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void userMessage;
            UserMessage userMessage2 = (UserMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (UserMessage)userMessage));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatMessageId, UserMessage> loadUserMessages(Set<ChatMessageId> chatMessageIds) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Map $this$mapValuesNotNull$iv = this.chatMessageService.findByIds(chatMessageIds);
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            ChatMessage message = (ChatMessage)entry.getValue();
            if ((message instanceof UserMessage ? (UserMessage)message : null) != null) {
                UserMessage it$iv;
                it$iv = it$iv;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, Chat> loadChats(Set<ChatId> chatIds2) {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.chatService.findByIds(chatIds2);
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Chat chat = (Chat)entry.getValue();
            if (!(!(chat instanceof OneOnOneChat) || chat.getLastMessageId() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, List<Profile>> loadOneOnOneChatPartners(Map<ChatId, ? extends Chat> chats2, Map<ChatId, ? extends List<ChatParticipant>> chatParticipants) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void $this$filterIsInstanceToSet$iv$iv;
        Iterable p0$iv;
        void $this$mapTo$iv$iv$iv;
        void $this$filterParticipantIds$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = chats2.values();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof OneOnOneChat)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set oneOnOneChatIds = (Set)destination$iv$iv;
        ChatParticipant.Companion $i$f$mapToSet22 = ChatParticipant.Companion;
        $this$mapTo$iv$iv = oneOnOneChatIds;
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ChatId chatId = $this$forEach$iv$iv$iv.iterator();
        while (chatId.hasNext()) {
            List<ChatParticipant> it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = chatId.next();
            boolean bl = false;
            ChatId p0 = (ChatId)element$iv$iv;
            boolean bl2 = false;
            if (chatParticipants.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        boolean $i$f$filterParticipantIds = false;
        Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
        boolean $i$f$map = false;
        void $i$f$mapNotNullTo22 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            element$iv$iv = (ChatParticipant)item$iv$iv$iv;
            Collection bl = destination$iv$iv$iv;
            boolean bl4 = false;
            bl.add(p0$iv.getParticipantId());
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
        destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Set oneOnOneChatPartnerIds = (Set)destination$iv$iv$iv;
        Map profilesById = this.profileService.findByIds(oneOnOneChatPartnerIds);
        Iterable $this$associateWith$iv = oneOnOneChatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void chatId2;
            chatId = (ChatId)element$iv$iv3;
            Object e = element$iv$iv3;
            object = result$iv;
            boolean bl = false;
            p0$iv = chatParticipants.getOrDefault(chatId2, CollectionsKt.emptyList());
            boolean $i$f$mapNotNull2 = false;
            void bl4 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                ChatParticipant participant = (ChatParticipant)element$iv$iv4;
                boolean bl6 = false;
                if ((Profile)profilesById.get(participant.getParticipantId()) == null) continue;
                boolean bl7 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            object.put(e, list);
        }
        return result$iv;
    }

    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents2) {
        if (documents2.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents2);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents2.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents2.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents2);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents2) {
        Iterable $this$forEach$iv = documents2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteByChatIds(SolrCore $this$deleteByChatIds, Set<ChatId> chatIds2) {
        void $this$mapTo$iv$iv;
        if (chatIds2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = chatIds2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)20);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            try {
                LOG.info("Delete from " + $this$deleteByChatIds.getCoreName() + " core by chat_id = " + chunk);
                $this$deleteByChatIds.getClient().deleteByQuery(CollectionsKt.joinToString$default((Iterable)chunk, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)deleteByChatIds.2.1.INSTANCE), (int)30, null));
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.warn("Failed to delete by chatIds = " + chunk + " for for solr core " + $this$deleteByChatIds.getCoreName() + ". Deletion will be skipped!", (Throwable)e);
            }
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private boolean isReindexingChatCore() {
        Thread thread = this.chatCoreReindexThread;
        return thread != null ? thread.isAlive() : false;
    }

    private ChatId getChatId(ConsumerRecord<String, String> $this$getChatId) {
        ChatId chatId;
        try {
            Object object = $this$getChatId.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
            chatId = ChatId.Companion.fromCanonicalId((String)object);
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse record[key=" + $this$getChatId.key() + ", value=" + $this$getChatId.value() + "] to chat id. We will skip this record.", e);
            chatId = null;
        }
        return chatId;
    }

    /*
     * WARNING - void declaration
     */
    private List<SearchId> toSearchIds(ConsumerRecord<String, String> $this$toSearchIds) {
        Object object;
        try {
            void $this$readValue$iv;
            object = (ObjectMapper)KafkaObjectMapper.INSTANCE;
            Object object2 = $this$toSearchIds.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = (List)$this$readValue$iv.readValue(content$iv, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse record[key=" + $this$toSearchIds.key() + ", value=" + $this$toSearchIds.value() + "] to search id. We will skip this record.", e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final void reindexChatsInCommonCore$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CommonCoreSearchUpdateIndexProducer access$getCommonCoreSearchUpdateIndexProducer$p(SolrIndexService $this) {
        return $this.commonCoreSearchUpdateIndexProducer;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ SolrClient access$getChatCoreLeaderSolrClient$p(SolrIndexService $this) {
        return $this.chatCoreLeaderSolrClient;
    }

    public static final /* synthetic */ ChatCoreSearchUpdateIndexProducer access$getChatCoreSearchUpdateIndexProducer$p(SolrIndexService $this) {
        return $this.chatCoreSearchUpdateIndexProducer;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

