/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka.search;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ChatsDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.kafka.search.CommonCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.search.shared.SolrIndexQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0011\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0014H\u0011\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0017H\u0011\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0011\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u001dH\u0011\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000eH\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/search/shared/SolrIndexQueue;)V", "fullIndex", "", "ids", "", "Lde/justsoftware/chat/model/ChatId;", "handleChatCreated", "evt", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "handleChatCreated$chat_service", "handleChatParticipantsChanged", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "handleChatParticipantsChanged$chat_service", "handleChatUpdated", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "handleChatUpdated$chat_service", "handleChatsDeleted", "Lde/justsoftware/chat/business/model/event/ChatsDeletedEvent;", "handleChatsDeleted$chat_service", "handleProfileUpdated", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "handleProfileUpdated$chat_service", "send", "id", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nCommonCoreSearchUpdateIndexProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n1855#2,2:77\n1549#2:79\n1620#2,3:80\n1855#2,2:83\n1549#2:85\n1620#2,3:86\n*S KotlinDebug\n*F\n+ 1 CommonCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer\n*L\n24#1:75,2\n43#1:77,2\n44#1:79\n44#1:80,3\n56#1:83,2\n57#1:85\n57#1:86,3\n*E\n"})
public class CommonCoreSearchUpdateIndexProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    public static final String TOPIC = "just.chat-service.search.common.updateIndex";

    public CommonCoreSearchUpdateIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatParticipantService chatParticipantService, @NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.kafkaProducer = kafkaProducer;
        this.chatParticipantService = chatParticipantService;
        this.solrIndexQueue = solrIndexQueue;
    }

    public void fullIndex(@NotNull Set<ChatId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
    }

    @EventListener
    public void handleChatCreated$chat_service(@NotNull ChatCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChat() instanceof MultiUserChat) {
            this.send(evt.getChatId());
            this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)evt.getChatId().toSearchableId()));
        }
    }

    @EventListener
    public void handleChatUpdated$chat_service(@NotNull ChatUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)evt.getChatId().toSearchableId()));
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void handleChatsDeleted$chat_service(@NotNull ChatsDeletedEvent evt) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = evt.getChatIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
        $this$forEach$iv = evt.getChatIds();
        SolrIndexQueue solrIndexQueue = this.solrIndexQueue;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toSearchableId());
        }
        solrIndexQueue.queueFullIndex((List)destination$iv$iv);
    }

    @EventListener
    public void handleChatParticipantsChanged$chat_service(@NotNull ChatParticipantsChangedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)evt.getChatId().toSearchableId()));
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void handleProfileUpdated$chat_service(@NotNull ProfileUpdatedEvent evt) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Set ids = this.chatParticipantService.findOneOnOneChatIdsByProfileId(evt.getProfileId());
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
        $this$forEach$iv = ids;
        SolrIndexQueue solrIndexQueue = this.solrIndexQueue;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toSearchableId());
        }
        solrIndexQueue.queueFullIndex((List)destination$iv$iv);
    }

    private void send(ChatId id) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)id.toCanonicalId(), (Object)id.toCanonicalId()));
    }
}

