/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.controller;

import de.justsoftware.chat.application.PermissionApplicationService;
import de.justsoftware.chat.application.SettingsApplicationService;
import de.justsoftware.chat.application.XmppApplicationService;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import io.micrometer.observation.annotation.Observed;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Observed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u0012\u0010\u0014\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u00162\u000e\b\u0001\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0017J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00130\u00162\u000e\b\u0001\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH\u0017J\b\u0010\u001f\u001a\u00020\u0010H\u0017J\b\u0010 \u001a\u00020\u0010H\u0017J\b\u0010!\u001a\u00020\u0010H\u0017R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/chat/controller/InternalController;", "", "permissionApplicationService", "Lde/justsoftware/chat/application/PermissionApplicationService;", "xmppApplicationService", "Lde/justsoftware/chat/application/XmppApplicationService;", "solrIndexService", "Lde/justsoftware/chat/search/SolrIndexService;", "settingsApplicationService", "Lde/justsoftware/chat/application/SettingsApplicationService;", "mobileApplicationService", "Lde/justsoftware/chat/mobile/service/MobileApplicationService;", "justVersion", "", "(Lde/justsoftware/chat/application/PermissionApplicationService;Lde/justsoftware/chat/application/XmppApplicationService;Lde/justsoftware/chat/search/SolrIndexService;Lde/justsoftware/chat/application/SettingsApplicationService;Lde/justsoftware/chat/mobile/service/MobileApplicationService;Ljava/lang/String;)V", "clearAndSyncChatNodes", "", "disableChatNotifications", "personId", "", "enableChatNotifications", "getChatNotifications", "", "", "personIds", "", "getIosUnreadMessageCounts", "Lde/justsoftware/chat/model/ProfileId;", "profileIds", "publishAllPermissions", "Lkotlin/Function0;", "reindexAll", "reindexChatCore", "reindexChatsInCommonCore", "chat-service"})
@SourceDebugExtension(value={"SMAP\nInternalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalController.kt\nde/justsoftware/chat/controller/InternalController\n+ 2 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,74:1\n7#2:75\n1620#3,3:76\n1238#3,4:81\n468#4:79\n414#4:80\n*S KotlinDebug\n*F\n+ 1 InternalController.kt\nde/justsoftware/chat/controller/InternalController\n*L\n59#1:75\n59#1:76,3\n60#1:81,4\n60#1:79\n60#1:80\n*E\n"})
public class InternalController {
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final XmppApplicationService xmppApplicationService;
    @NotNull
    private final SolrIndexService solrIndexService;
    @NotNull
    private final SettingsApplicationService settingsApplicationService;
    @NotNull
    private final MobileApplicationService mobileApplicationService;
    @NotNull
    private final String justVersion;

    public InternalController(@NotNull PermissionApplicationService permissionApplicationService, @NotNull XmppApplicationService xmppApplicationService, @NotNull SolrIndexService solrIndexService, @NotNull SettingsApplicationService settingsApplicationService, @NotNull MobileApplicationService mobileApplicationService, @Value(value="${just.version}") @NotNull String justVersion) {
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)xmppApplicationService, (String)"xmppApplicationService");
        Intrinsics.checkNotNullParameter((Object)solrIndexService, (String)"solrIndexService");
        Intrinsics.checkNotNullParameter((Object)settingsApplicationService, (String)"settingsApplicationService");
        Intrinsics.checkNotNullParameter((Object)mobileApplicationService, (String)"mobileApplicationService");
        Intrinsics.checkNotNullParameter((Object)justVersion, (String)"justVersion");
        this.permissionApplicationService = permissionApplicationService;
        this.xmppApplicationService = xmppApplicationService;
        this.solrIndexService = solrIndexService;
        this.settingsApplicationService = settingsApplicationService;
        this.mobileApplicationService = mobileApplicationService;
        this.justVersion = justVersion;
    }

    @GetMapping(value={"just/version"})
    @NotNull
    public String justVersion() {
        return this.justVersion;
    }

    @PostMapping(value={"publish/permissions"})
    @NotNull
    public Function0<Unit> publishAllPermissions() {
        return this.permissionApplicationService.republishPermissions();
    }

    @PostMapping(value={"xmpp/resyncChatNodes"})
    public void clearAndSyncChatNodes() {
        this.xmppApplicationService.clearAndSyncChatNodes();
    }

    @PostMapping(value={"search/reindexAll"})
    public void reindexAll() {
        this.solrIndexService.reindexAll();
    }

    @PostMapping(value={"search/reindexChatsInCommonCore"})
    public void reindexChatsInCommonCore() {
        this.solrIndexService.reindexChatsInCommonCore();
        this.solrIndexService.reindexJustSocialCore();
    }

    @PostMapping(value={"search/reindexChatCore"})
    public void reindexChatCore() {
        this.solrIndexService.reindexChatCore();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"settings/chatNotifications"})
    @NotNull
    public Map<Long, Boolean> getChatNotifications(@RequestBody @NotNull List<Long> personIds) {
        void $this$mapKeysTo$iv$iv;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(personIds, (String)"personIds");
        Iterable iterable = personIds;
        Object object = this.settingsApplicationService;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            Object item$iv$iv = iterator.next();
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId((long)p0));
        }
        Map $this$mapKeys$iv = object.getMailDeliveryEnabledSettingsForProfileIds((Set)destination$iv$iv);
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Long l = (long)profileId.getValue();
            Object object2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            object2.put(l, entry);
        }
        return destination$iv$iv;
    }

    @PostMapping(value={"settings/chatNotifications/{personId}/enable"})
    public void enableChatNotifications(@PathVariable(value="personId") long personId) {
        this.settingsApplicationService.saveMailDeliveryEnabledSettingForProfile(new ProfileId(personId), true);
    }

    @PostMapping(value={"settings/chatNotifications/{personId}/disable"})
    public void disableChatNotifications(@PathVariable(value="personId") long personId) {
        this.settingsApplicationService.saveMailDeliveryEnabledSettingForProfile(new ProfileId(personId), false);
    }

    @PostMapping(value={"messages/unread/ios"})
    @NotNull
    public Map<ProfileId, Long> getIosUnreadMessageCounts(@RequestBody @NotNull List<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.mobileApplicationService.getIosUnreadMessageCounts(CollectionsKt.toSet((Iterable)profileIds));
    }
}

