/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user.persistence;

import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.persistence.repository.ProfileRepository;
import de.justsoftware.admin.id.ProfileId;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "", "repository", "Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;", "(Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;)V", "delete", "", "id", "Lde/justsoftware/admin/id/ProfileId;", "getByIds", "", "Lde/justsoftware/admin/domain/user/model/Profile;", "ids", "", "save", "profile", "admin-service"})
public class ProfileDao {
    @NotNull
    private final ProfileRepository repository;

    public ProfileDao(@NotNull ProfileRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public void save(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.repository.insertOrUpdate(profile.getId(), profile.getTenantId(), profile.getFirstName(), profile.getLastName(), profile.getEmail(), profile.getImageUrl(), profile.getActive(), profile.getBlocked());
    }

    public void delete(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.delete(id);
    }

    @NotNull
    public Set<Profile> getByIds(@NotNull Collection<ProfileId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return SetsKt.emptySet();
        }
        return this.repository.getByIds(ids);
    }
}

