/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.authentication.service.CertificateStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.HttpsURLConnection;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.stereotype.Service;

@Service(value="keyManager")
@ParametersAreNonnullByDefault
public class SecretManager
extends AbstractCriteriaFilteringCredentialResolver
implements KeyManager {
    private static final BouncyCastleProvider BC = new BouncyCastleProvider();
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretManager.class);
    private final CertificateStore _certStore;

    @Autowired
    public SecretManager(CertificateStore certStore) {
        this._certStore = certStore;
    }

    public void setIdentityProvider(String metadataURI) throws MalformedURLException, IOException, IllegalArgumentException {
        URL url = new URL(metadataURI);
        this._certStore.setCertificateChain(url.getHost(), this.getCertificates(metadataURI));
        this._certStore.setIdentityProvider(url.getHost());
    }

    public void setServiceProvider(String entityId, String domain, String privateSslKey) {
        try {
            this._certStore.setCertificateChain(entityId, this.getCertificates(domain));
            this._certStore.setPrivateKey(entityId, this.loadPrivateKey(privateSslKey));
            this._certStore.setServiceProvider(entityId);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.error("Error loading own public certificate or adding own SP certificate and keys to key store", (Throwable)e);
            throw new SAMLRuntimeException("Error adding own SP certificate and keys to key store", e);
        }
    }

    @Nonnull
    private PrivateKey loadPrivateKey(String privateSslKey) throws PEMException, IOException {
        return new JcaPEMKeyConverter().setProvider((Provider)BC).getPrivateKey(this.getPrivateKeyInfo(privateSslKey));
    }

    @Nonnull
    private PrivateKeyInfo getPrivateKeyInfo(String privateSslKey) throws IOException {
        try (PEMParser reader = new PEMParser((Reader)new StringReader(privateSslKey));){
            Object keyObject = reader.readObject();
            if (keyObject == null) {
                throw new SAMLRuntimeException("Can't read private ssl key: \n" + privateSslKey);
            }
            if (keyObject instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)PrivateKeyInfo.class.cast(keyObject);
                return privateKeyInfo;
            }
            if (keyObject instanceof PEMEncryptedKeyPair) {
                PrivateKeyInfo privateKeyInfo = ((PEMEncryptedKeyPair)PEMEncryptedKeyPair.class.cast(keyObject)).decryptKeyPair(new JcePEMDecryptorProviderBuilder().build("".toCharArray())).getPrivateKeyInfo();
                return privateKeyInfo;
            }
            PrivateKeyInfo privateKeyInfo = ((PEMKeyPair)PEMKeyPair.class.cast(keyObject)).getPrivateKeyInfo();
            return privateKeyInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<X509Certificate> getCertificates(String domain) throws IOException, IllegalArgumentException {
        URL url = new URL(domain);
        URLConnection conn = url.openConnection();
        if (!HttpsURLConnection.class.isInstance(conn)) {
            throw new IllegalArgumentException(domain + " does not support https");
        }
        conn.setReadTimeout(15000);
        conn.setConnectTimeout(15000);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)HttpsURLConnection.class.cast(conn);
        try {
            httpsConnection.connect();
            ImmutableList immutableList = FluentIterable.from((Object[])httpsConnection.getServerCertificates()).filter(X509Certificate.class).toList();
            return immutableList;
        }
        finally {
            httpsConnection.disconnect();
        }
    }

    public X509Certificate getCertificate(String alias) {
        LOGGER.debug("get certificate for alias {}", (Object)alias);
        if (alias == null || alias.length() == 0) {
            return null;
        }
        return this._certStore.getCertificate(alias);
    }

    public Credential getCredential(String keyName) {
        LOGGER.debug("get credential for key {}", (Object)keyName);
        try {
            return this.resolveSingle(new CriteriaSet((Criteria)new EntityIDCriteria(keyName != null ? keyName : this.getDefaultCredentialName())));
        }
        catch (SecurityException e) {
            throw new SAMLRuntimeException("Can't obtain SP signing key", (Exception)((Object)e));
        }
    }

    public Credential getDefaultCredential() {
        return this.getCredential(this.getDefaultCredentialName());
    }

    public String getDefaultCredentialName() {
        String defaultCredentialName = this._certStore.getServiceProvider();
        LOGGER.debug("default credential name: {}", (Object)defaultCredentialName);
        return defaultCredentialName;
    }

    public Set<String> getAvailableCredentials() {
        Set result = this._certStore.getAliases();
        LOGGER.debug("available credentials: {}", (Object)result);
        return result;
    }

    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) {
        X509Certificate cert;
        EntityIDCriteria entityCriteria = (EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class);
        if (entityCriteria == null) {
            LOGGER.error("EntityIDCriteria was not specified in the criteria set, resolution can not be attempted");
            throw new IllegalArgumentException("No EntityIDCriteria was available in criteria set");
        }
        String entityId = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        LOGGER.debug("resolveFromSource for entityID {}", (Object)entityId);
        ImmutableList.Builder builder = ImmutableList.builder();
        PrivateKey privateKey = this._certStore.getPrivateKey(entityId);
        List chain = this._certStore.getCertificateChain(entityId);
        X509Certificate x509Certificate = cert = !chain.isEmpty() ? (X509Certificate)chain.get(0) : null;
        if (privateKey != null && cert != null && !chain.isEmpty()) {
            BasicX509Credential credential = new BasicX509Credential();
            credential.setPrivateKey(privateKey);
            credential.setEntityCertificate(cert);
            credential.setEntityCertificateChain((Collection)chain);
            credential.setEntityId(entityId);
            builder.add((Object)credential);
        } else {
            LOGGER.error("resolveFromSource for entityID {} failed, couldn't find private key or its chain", (Object)entityId);
        }
        return builder.build();
    }

    static {
        Security.addProvider((Provider)BC);
    }
}

