#!/bin/bash

check_solr_core_initialized() {
    sleep 900
    FAILED=$(curl "http://localhost:8983/solr/admin/cores?action=STATUS" -H 'accept: application/json' 2>/dev/null | jq ".initFailures" | jq length)
    if [[ FAILED -gt 0 ]]; then
        /bin/sudo /bin/systemctl restart just-solr
    fi
    CORE_COUNT=$(curl "http://localhost:8983/solr/admin/cores?action=STATUS" -H 'accept: application/json' 2>/dev/null | jq ".status" | jq length)
    # we have 4 solr cores: common, people, chat, justsocial
    if [[ CORE_COUNT -lt 4 ]]; then
        /bin/sudo /bin/systemctl restart just-solr
    fi
}

check_solr_core_initialized &
