#!/usr/bin/env bash

APISTRING="toro/api/v.*/person/current"
ACCESSLOG="/var/log/apache2/justconnect-https-access.log"
TIMEFRAME=`date -d"now-30minutes" '+%s'`

check_mobile_logins()
{
   nrpecheckmobileLOGINS=0
   cat $ACCESSLOG | grep $APISTRING | 
   {
      while read LINE; do
         TEMPDATE=`echo $LINE | awk '{print $4}' | sed 's/\[//g' | sed 's/\//\-/g' | sed 's/:/\ /'`
         SINCEDATE=`date -d "$TEMPDATE" '+%s'`
         if [ $SINCEDATE -gt $TIMEFRAME ]; then
            nrpecheckmobileLOGINS=$(($nrpecheckmobileLOGINS+1))
         fi
      done
      echo "Mobile Logins $nrpecheckmobileLOGINS | mobilelogins=$nrpecheckmobileLOGINS"
   }
exit 0
}

check_mobile_logins
