#!/usr/bin/env bash

HOSTNAME="localhost"
PORT=8080
QUEUE="search-index"

THROUGHPUT=""
AVG=""
MIN=""
MAX=""
QSIZE=""

W_LVL_AVG=45000
C_LVL_AVG=60000
W_LVL_MAX=90000
C_LVL_MAX=120000
W_LVL_QSIZE=22500
C_LVL_QSIZE=30000

WARNING_STATUS=1;
CRITICAL_STATUS=2;
OK_STATUS=0;

RETURN_STATUS="$OK_STATUS"

usage ()
{
    echo "Usage: `basename $0` [ -H hostname or IP address ] [ -P port ] [ -n queue-name ] [ -a warning level AVG ] [ -A critical level AVG ] [ -m warning level MAX] [ -M critical level MAX ] [ -q warning level queue size ] [ -Q critical level queue size ] [ -h usage ]" >&2
    echo "Valid queue names are: [ search-index | update-event | export-event | chat-search | conversation-search | item-visibility]"
    exit 1
}

while getopts ":H:P:n:a:A:m:M:q:Q:h" opt
do
    case "$opt" in
        H)
            HOSTNAME="$OPTARG"
        ;;
        P)
            PORT="$OPTARG"
        ;;
        n)
            QUEUE="$OPTARG"
        ;;
        a)
            W_LVL_AVG="$OPTARG"
        ;;
        A)
            C_LVL_AVG="$OPTARG"
        ;;
        m)
            W_LVL_MAX="$OPTARG"
        ;;
        M)
            C_LVL_MAX="$OPTARG"
        ;;
        q)
            W_LVL_QSIZE="$OPTARG"
        ;;
        Q)
            C_LVL_QSIZE="$OPTARG"
        ;;
        h)
            usage
            exit 1
        ;;
    esac
done

list=$(curl -sfkL --connect-timeout 2 http://$HOSTNAME:$PORT/toro/monitoring/queues/$QUEUE)
result=$?
if [ $result -ne 0 ]; then
   echo "[ERROR] cannot check messages on $HOSTNAME."
   exit "$CRITICAL_STATUS"
else
    while read line; do
        service=$(echo $line | cut -d '=' -f 1)
        status=$(echo $line | cut -d '=' -f 2)
        
        case "$service" in 
            "THROUGHPUT")
                THROUGHPUT="$status"
                ;;
            "AVG")
                AVG="$status"
                if [ $AVG -ge $C_LVL_AVG ]; then
                    RETURN_STATUS=$CRITICAL_STATUS
                elif [ $AVG -ge $W_LVL_AVG ]; then
                    RETURN_STATUS=$WARNING_STATUS
                fi
                ;;
            "MIN")
                MIN="$status"
                ;;
            "MAX")
                MAX="$status"
                if [ $MAX -ge $C_LVL_MAX ]; then
                    RETURN_STATUS=$CRITICAL_STATUS
                elif [ $MAX -ge $W_LVL_MAX ]; then
                    RETURN_STATUS=$WARNING_STATUS
                fi
                ;;
            "QSIZE")
                QSIZE="$status"
                if [ $QSIZE -ge $C_LVL_QSIZE ]; then
                    RETURN_STATUS=$CRITICAL_STATUS
                elif [ $QSIZE -ge $W_LVL_QSIZE ]; then
                    RETURN_STATUS=$WARNING_STATUS
                fi
                ;;
        esac
                
    done < <(echo "$list" | tr -d "\r")
      
fi

perfData="THROUGHPUT=$THROUGHPUT;AVG=$AVG;$W_LVL_AVG;$C_LVL_AVG;0;MIN=$MIN;MAX=$MAX;$W_LVL_MAX;$C_LVL_MAX;0;QSIZE=$QSIZE;$W_LVL_QSIZE;$C_LVL_QSIZE;0;"

if [ $RETURN_STATUS -eq $OK_STATUS ]; then
    echo "OK | $perfData"
elif [ $RETURN_STATUS -eq $WARNING_STATUS ]; then
    echo "WARNING | $perfData"
elif [ $RETURN_STATUS -eq $CRITICAL_STATUS ]; then
    echo "CRITICAL | $perfData"
else
    echo "UNKNOWN | $perfData"
fi
exit "$RETURN_STATUS";    
