/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.application.ConfigApplicationService;
import de.justsoftware.people.application.model.CreateLinkDto;
import de.justsoftware.people.application.utils.JustJavascriptUtils;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.model.AbstractId;
import de.justsoftware.people.model.ExternalLinkId;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ConfigApplicationServiceImpl
implements ConfigApplicationService {
    private final ExternalLinkService _linkService;

    @Autowired
    public ConfigApplicationServiceImpl(ExternalLinkService linkService) {
        this._linkService = linkService;
    }

    public ExternalLinkId createExternalLink(TenantId tenantId, CreateLinkDto createLinkDto, AuthorizationContext authorizationContext) {
        authorizationContext.check(StaticAction.MANAGE, (AbstractId)tenantId);
        ProfileId linkCreator = authorizationContext.getProfileId();
        LinkConfigCreateModel safeExternalLink = new LinkConfigCreateModel(this.escape(createLinkDto.getUri()), this.escape(createLinkDto.getDescription()));
        return this._linkService.createExternalLink(tenantId, safeExternalLink, linkCreator);
    }

    @Nonnull
    public List<ExternalLinkConfig> getExternalLinks(TenantId tenantId, AuthorizationContext authorizationContext) {
        authorizationContext.check(StaticAction.READ, (AbstractId)tenantId);
        return this._linkService.getConfiguredLinks(tenantId);
    }

    public void deleteExternalLinks(TenantId tenantId, List<ExternalLinkId> linkIds, AuthorizationContext authorizationContext) {
        authorizationContext.check(StaticAction.MANAGE, (AbstractId)tenantId);
        this._linkService.deleteExternalLinks(tenantId, (Set)ImmutableSet.copyOf(linkIds));
    }

    @Nonnull
    private String escape(String input) {
        return JustJavascriptUtils.javaScriptEscape((String)input);
    }
}

