/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence.model;

import de.justsoftware.notificationservice.persistence.model.DbAuditModel;
import de.justsoftware.notificationservice.persistence.model.DbUserGroupMemberId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Entity
@Table(name="UserGroupMember")
@ParametersAreNonnullByDefault
@IdClass(value=DbUserGroupMemberId.class)
public class DbUserGroupMember
extends DbAuditModel {
    private static final long serialVersionUID = 7800881793182417722L;
    private UUID _groupId;
    private Long _profileId;

    @Deprecated
    public DbUserGroupMember() {
    }

    public DbUserGroupMember(Long profileId, UUID groupId) {
        this._profileId = profileId;
        this._groupId = groupId;
    }

    public DbUserGroupMember(DbUserGroupMemberId id) {
        this._profileId = id.getProfileId();
        this._groupId = id.getGroupId();
    }

    @Id
    @Nonnull
    public UUID getGroupId() {
        return this._groupId;
    }

    public void setGroupId(UUID groupId) {
        this._groupId = groupId;
    }

    @Id
    @Nonnull
    public Long getProfileId() {
        return this._profileId;
    }

    public void setProfileId(Long profileId) {
        this._profileId = profileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbUserGroupMember)) {
            return false;
        }
        DbUserGroupMember that = (DbUserGroupMember)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getProfileId(), that.getProfileId());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getProfileId());
    }
}

