/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;

public class VersionRange {
    public static final VersionRange ALL = VersionRange.of((short)0, (short)Short.MAX_VALUE);
    private final short min;
    private final short max;

    private VersionRange(short min, short max) {
        this.min = min;
        this.max = max;
    }

    public static VersionRange of(short min, short max) {
        return new VersionRange(min, max);
    }

    public static VersionRange of(int min, int max) {
        return new VersionRange((short)min, (short)max);
    }

    public short min() {
        return this.min;
    }

    public short max() {
        return this.max;
    }

    public boolean contains(short version) {
        return version >= this.min && version <= this.max;
    }

    public boolean intersects(VersionRange other) {
        return other.min <= this.max && other.max >= this.min;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)o;
        return other.min == this.min && other.max == this.max;
    }

    public String toString() {
        if (this.min == this.max) {
            return String.valueOf(this.min);
        }
        if (this.max == Short.MAX_VALUE) {
            return String.valueOf(this.min) + "+";
        }
        return String.valueOf(this.min) + "-" + String.valueOf(this.max);
    }
}

