/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.kafka.connect.runtime.rest.resources.ConnectResource;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@Path(value="/admin/loggers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LoggingResource
implements ConnectResource {
    private static final String ROOT_LOGGER_NAME = "root";

    @Override
    public void requestTimeout(long requestTimeoutMs) {
    }

    @GET
    @Path(value="/")
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels")
    public Response listLoggers() {
        TreeMap<String, Map<String, String>> loggers = new TreeMap<String, Map<String, String>>();
        Enumeration<Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> loggers.put(logger.getName(), LoggingResource.levelToMap(logger)));
        Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            loggers.put(ROOT_LOGGER_NAME, LoggingResource.levelToMap(root));
        }
        return Response.ok(loggers).build();
    }

    @GET
    @Path(value="/{logger}")
    @Operation(summary="Get the log level for the specified logger")
    public Response getLogger(@PathParam(value="logger") String namedLogger) {
        Objects.requireNonNull(namedLogger, "require non-null name");
        Logger logger = null;
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namedLogger)) {
            logger = this.rootLogger();
        } else {
            Enumeration<Logger> en = this.currentLoggers();
            while (en.hasMoreElements()) {
                Logger l = en.nextElement();
                if (!namedLogger.equals(l.getName())) continue;
                logger = l;
                break;
            }
        }
        if (logger == null) {
            throw new NotFoundException("Logger " + namedLogger + " not found.");
        }
        return Response.ok(LoggingResource.effectiveLevelToMap(logger)).build();
    }

    @PUT
    @Path(value="/{logger}")
    @Operation(summary="Set the level for the specified logger")
    public Response setLevel(@PathParam(value="logger") String namedLogger, Map<String, String> levelMap) {
        ArrayList<Object> childLoggers;
        String desiredLevelStr = levelMap.get("level");
        if (desiredLevelStr == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        Level level = Level.toLevel((String)desiredLevelStr.toUpperCase(Locale.ROOT), null);
        if (level == null) {
            throw new NotFoundException("invalid log level '" + desiredLevelStr + "'.");
        }
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namedLogger)) {
            childLoggers = Collections.list(this.currentLoggers());
            childLoggers.add(this.rootLogger());
        } else {
            boolean bl;
            childLoggers = new ArrayList();
            Logger ancestorLogger = this.lookupLogger(namedLogger);
            Enumeration<Logger> en = this.currentLoggers();
            boolean bl2 = false;
            while (en.hasMoreElements()) {
                Logger current = en.nextElement();
                if (current.getName().startsWith(namedLogger)) {
                    childLoggers.add(current);
                }
                if (!namedLogger.equals(current.getName())) continue;
                bl = true;
            }
            if (!bl) {
                childLoggers.add(ancestorLogger);
            }
        }
        ArrayList<String> modifiedLoggerNames = new ArrayList<String>();
        for (Logger logger : childLoggers) {
            logger.setLevel(level);
            modifiedLoggerNames.add(logger.getName());
        }
        Collections.sort(modifiedLoggerNames);
        return Response.ok(modifiedLoggerNames).build();
    }

    protected Logger lookupLogger(String namedLogger) {
        return LogManager.getLogger((String)namedLogger);
    }

    protected Enumeration<Logger> currentLoggers() {
        return LogManager.getCurrentLoggers();
    }

    protected Logger rootLogger() {
        return LogManager.getRootLogger();
    }

    private static Map<String, String> effectiveLevelToMap(Logger logger) {
        Level level = logger.getLevel();
        if (level == null) {
            level = logger.getEffectiveLevel();
        }
        return Collections.singletonMap("level", String.valueOf(level));
    }

    private static Map<String, String> levelToMap(Logger logger) {
        return Collections.singletonMap("level", String.valueOf(logger.getLevel()));
    }
}

