/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence.model;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.AuditModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/wikiservice/persistence/model/Permission;", "Lde/justsoftware/wikiservice/persistence/model/AuditModel;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "type", "Lde/justsoftware/wikiservice/model/PermissionType;", "role", "Lde/justsoftware/permission/client/model/Role;", "(Lde/justsoftware/wikiservice/model/WikiId;Lde/justsoftware/wikiservice/model/PermissionType;Lde/justsoftware/permission/client/model/Role;)V", "granteeId", "Lde/justsoftware/wikiservice/model/GranteeId;", "(Lde/justsoftware/wikiservice/model/WikiId;Lde/justsoftware/wikiservice/model/PermissionType;Lde/justsoftware/wikiservice/model/GranteeId;)V", "getGranteeId", "()Lde/justsoftware/wikiservice/model/GranteeId;", "setGranteeId", "(Lde/justsoftware/wikiservice/model/GranteeId;)V", "id", "Lde/justsoftware/wikiservice/model/PermissionId;", "getId", "()Lde/justsoftware/wikiservice/model/PermissionId;", "setId", "(Lde/justsoftware/wikiservice/model/PermissionId;)V", "getType", "()Lde/justsoftware/wikiservice/model/PermissionType;", "setType", "(Lde/justsoftware/wikiservice/model/PermissionType;)V", "getWikiId", "()Lde/justsoftware/wikiservice/model/WikiId;", "setWikiId", "(Lde/justsoftware/wikiservice/model/WikiId;)V", "wiki-service"})
public final class Permission
extends AuditModel {
    @Embedded
    @AttributeOverride(name="id", column=@Column(name="wikiId"))
    @NotNull
    private WikiId wikiId;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private PermissionType type;
    @Embedded
    @AttributeOverride(name="granteeId", column=@Column(name="granteeId"))
    @NotNull
    private GranteeId granteeId;
    @GenericGenerator(name="PermissionId-generator", strategy="de.justsoftware.wikiservice.model.PermissionId")
    @GeneratedValue(generator="PermissionId-generator")
    @AttributeOverride(name="id", column=@Column(name="id"))
    @EmbeddedId
    @Nullable
    private PermissionId id;

    public Permission(@NotNull WikiId wikiId, @NotNull PermissionType type, @NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        this.wikiId = wikiId;
        this.type = type;
        this.granteeId = granteeId;
    }

    @NotNull
    public final WikiId getWikiId() {
        return this.wikiId;
    }

    public final void setWikiId(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"<set-?>");
        this.wikiId = wikiId;
    }

    @NotNull
    public final PermissionType getType() {
        return this.type;
    }

    public final void setType(@NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"<set-?>");
        this.type = permissionType;
    }

    @NotNull
    public final GranteeId getGranteeId() {
        return this.granteeId;
    }

    public final void setGranteeId(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"<set-?>");
        this.granteeId = granteeId;
    }

    @Nullable
    public final PermissionId getId() {
        return this.id;
    }

    public final void setId(@Nullable PermissionId permissionId) {
        this.id = permissionId;
    }

    public Permission(@NotNull WikiId wikiId, @NotNull PermissionType type, @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this(wikiId, type, GranteeId.Companion.toGranteeId(role));
    }

    public Permission() {
    }
}

