/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.kafka.TenantsKafkaConsumer;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.record.TimestampType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer;", "", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "(Lde/justsoftware/wikiservice/business/DeletionService;)V", "onTenantChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/wikiservice/model/TenantId;", "", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTenantsKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantsKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 TenantsKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer\n*L\n28#1:61,2\n*E\n"})
public class TenantsKafkaConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeletionService deletionService;
    @NotNull
    public static final String TOPIC = "just.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(TenantsKafkaConsumer.class);

    @Autowired
    public TenantsKafkaConsumer(@NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.deletionService = deletionService;
    }

    @KafkaListener(id="tenantsConsumer", containerFactory="tenantsConsumerFactory", topics={"just.tenants"}, idIsGroup=false)
    public void onTenantChanged(@NotNull ConsumerRecords<TenantId, String> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                if (record.value() != null || record.timestampType() != TimestampType.CREATE_TIME) continue;
                Instant recordCreatedAt = Instant.ofEpochMilli(record.timestamp());
                TenantId tenantId = (TenantId)record.key();
                Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"tenantId");
                Intrinsics.checkNotNullExpressionValue((Object)recordCreatedAt, (String)"recordCreatedAt");
                this.deletionService.deleteWikisInTenant(tenantId, recordCreatedAt);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process TenantId changes with key = " + record.key() + ". Skip this record.", (Throwable)e);
            }
        }
    }
}

