/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.kafka.ProfileKafkaConsumer;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.persistence.model.Profile;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/kafka/ProfileKafkaConsumer;", "", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "(Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/business/PermissionService;)V", "onProfileUpdate", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/wikiservice/model/ProfileId;", "Lde/justsoftware/wikiservice/persistence/model/Profile;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProfileKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/ProfileKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1855#2,2:51\n*S KotlinDebug\n*F\n+ 1 ProfileKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/ProfileKafkaConsumer\n*L\n29#1:51,2\n*E\n"})
public class ProfileKafkaConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    public static final String TOPIC = "just.persons";
    @NotNull
    private static final Logger LOG;

    @Autowired
    public ProfileKafkaConsumer(@NotNull ProfileService profileService, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.profileService = profileService;
        this.permissionService = permissionService;
    }

    @KafkaListener(id="profileConsumer", containerFactory="profileConsumerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfileUpdate(@NotNull ConsumerRecords<ProfileId, Profile> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                Profile profile = (Profile)record.value();
                Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"profile");
                this.profileService.save(profile);
                if (!profile.getDeleted()) continue;
                this.permissionService.deletePermissionsForGrantee(profile.getId().toGranteeId());
            }
            catch (RuntimeException e) {
                LOG.error("Failed to save or update profile with id = " + ((Profile)record.value()).getId() + ". Skip this record.", (Throwable)e);
            }
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(ProfileKafkaConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ProfileKafkaConsumer::class.java)");
        LOG = logger;
    }
}

