/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.util;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/graphql/util/IdCoercing;", "I", "Lgraphql/schema/Coercing;", "", "converter", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)V", "parseLiteral", "input", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "parseValue", "serialize", "dataFetcherResult", "wiki-service"})
public final class IdCoercing<I>
implements Coercing<I, String> {
    @NotNull
    private final Function1<String, I> converter;

    public IdCoercing(@NotNull Function1<? super String, ? extends I> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.converter = converter;
    }

    @NotNull
    public String serialize(@NotNull Object dataFetcherResult) throws CoercingSerializeException {
        Intrinsics.checkNotNullParameter((Object)dataFetcherResult, (String)"dataFetcherResult");
        try {
            Object possibleId = dataFetcherResult;
            return String.valueOf(possibleId);
        }
        catch (RuntimeException e) {
            throw new CoercingSerializeException("Failed to serialize during coercion: ", (Throwable)e);
        }
    }

    public I parseValue(@NotNull Object input) throws CoercingParseValueException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            if (input instanceof String) {
                String possibleId = input.toString();
                return (I)this.converter.invoke((Object)possibleId);
            }
            throw new CoercingParseValueException("Unable to parse variable value " + input + " as a valid Id");
        }
        catch (RuntimeException e) {
            throw new CoercingParseValueException("Failed to parse value during coercion: ", (Throwable)e);
        }
    }

    public I parseLiteral(@NotNull Object input) throws CoercingParseLiteralException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            if (input instanceof StringValue) {
                String string = ((StringValue)input).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.value");
                String possibleId = string;
                return (I)this.converter.invoke((Object)possibleId);
            }
            throw new CoercingSerializeException("Unable to parse " + input + " as a valid Id");
        }
        catch (RuntimeException e) {
            throw new CoercingParseLiteralException("Failed to parse literal during coercion: ", (Throwable)e);
        }
    }
}

