/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.TableOfContentsApplicationService;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateTableOfContentsArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryTableOfContentsArgs;
import de.justsoftware.wikiservice.model.ParentId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/TableOfContentsFetcher;", "", "tableOfContentsApplicationService", "Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;", "(Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;)V", "byChapterId", "Lgraphql/schema/DataFetcher;", "Lde/justsoftware/wikiservice/business/model/TableOfContentsDto;", "getByChapterId", "()Lgraphql/schema/DataFetcher;", "byId", "getById", "byWikiId", "getByWikiId", "update", "", "wiki-service"})
public class TableOfContentsFetcher {
    @NotNull
    private final TableOfContentsApplicationService tableOfContentsApplicationService;
    @NotNull
    private final DataFetcher<TableOfContentsDto> byId;
    @NotNull
    private final DataFetcher<TableOfContentsDto> byWikiId;
    @NotNull
    private final DataFetcher<TableOfContentsDto> byChapterId;

    @Autowired
    public TableOfContentsFetcher(@NotNull TableOfContentsApplicationService tableOfContentsApplicationService) {
        Intrinsics.checkNotNullParameter((Object)tableOfContentsApplicationService, (String)"tableOfContentsApplicationService");
        this.tableOfContentsApplicationService = tableOfContentsApplicationService;
        this.byId = arg_0 -> TableOfContentsFetcher.byId$lambda$0(this, arg_0);
        this.byWikiId = arg_0 -> TableOfContentsFetcher.byWikiId$lambda$1(this, arg_0);
        this.byChapterId = arg_0 -> TableOfContentsFetcher.byChapterId$lambda$2(this, arg_0);
    }

    @NotNull
    public DataFetcher<TableOfContentsDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<TableOfContentsDto> getByWikiId() {
        return this.byWikiId;
    }

    @NotNull
    public DataFetcher<TableOfContentsDto> getByChapterId() {
        return this.byChapterId;
    }

    @NotNull
    public DataFetcher<Boolean> update() {
        return arg_0 -> TableOfContentsFetcher.update$lambda$3(this, arg_0);
    }

    private static final TableOfContentsDto byId$lambda$0(TableOfContentsFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        QueryTableOfContentsArgs args = new QueryTableOfContentsArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.tableOfContentsApplicationService.read(args.getId(), context.getAuthContext());
    }

    private static final TableOfContentsDto byWikiId$lambda$1(TableOfContentsFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return this$0.tableOfContentsApplicationService.read((ParentId)wiki.getId(), context.getAuthContext());
    }

    private static final TableOfContentsDto byChapterId$lambda$2(TableOfContentsFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ChapterDto chapter = (ChapterDto)object2;
        return this$0.tableOfContentsApplicationService.read((ParentId)chapter.getId(), context.getAuthContext());
    }

    private static final Boolean update$lambda$3(TableOfContentsFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationUpdateTableOfContentsArgs args = new MutationUpdateTableOfContentsArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.tableOfContentsApplicationService.update(args.getTableOfContents(), context.getAuthContext());
    }
}

