/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config.security.oAuth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/wikiservice/config/security/oAuth/JustOpaqueTokenIntrospector;", "Lorg/springframework/security/oauth2/server/resource/introspection/OpaqueTokenIntrospector;", "introspectionUri", "", "clientId", "clientSecret", "maxAccessTokenCacheSize", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "delegate", "principalCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lorg/springframework/security/oauth2/core/OAuth2AuthenticatedPrincipal;", "getPrincipalCache$annotations", "()V", "getPrincipalCache", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "extractAuthorities", "", "Lorg/springframework/security/core/GrantedAuthority;", "principal", "introspect", "token", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nJustOpaqueTokenIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustOpaqueTokenIntrospector.kt\nde/justsoftware/wikiservice/config/security/oAuth/JustOpaqueTokenIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1549#2:60\n1620#2,3:61\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 JustOpaqueTokenIntrospector.kt\nde/justsoftware/wikiservice/config/security/oAuth/JustOpaqueTokenIntrospector\n*L\n54#1:60\n54#1:61,3\n55#1:64\n55#1:65,3\n*E\n"})
public final class JustOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    @NotNull
    private final OpaqueTokenIntrospector delegate;
    @NotNull
    private final LoadingCache<String, OAuth2AuthenticatedPrincipal> principalCache;

    public JustOpaqueTokenIntrospector(@NotNull String introspectionUri, @NotNull String clientId, @NotNull String clientSecret, long maxAccessTokenCacheSize) {
        Intrinsics.checkNotNullParameter((Object)introspectionUri, (String)"introspectionUri");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        this.delegate = (OpaqueTokenIntrospector)new NimbusOpaqueTokenIntrospector(introspectionUri, clientId, clientSecret);
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).refreshAfterWrite(Duration.ofSeconds(5L)).maximumSize(maxAccessTokenCacheSize).recordStats().build(arg_0 -> JustOpaqueTokenIntrospector.principalCache$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"newBuilder()\n        // \u2026egate.introspect(token) }");
        this.principalCache = loadingCache;
    }

    @NotNull
    public final LoadingCache<String, OAuth2AuthenticatedPrincipal> getPrincipalCache() {
        return this.principalCache;
    }

    public static /* synthetic */ void getPrincipalCache$annotations() {
    }

    @NotNull
    public OAuth2AuthenticatedPrincipal introspect(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Object object = this.principalCache.get((Object)token);
        Intrinsics.checkNotNull((Object)object);
        OAuth2AuthenticatedPrincipal principal = (OAuth2AuthenticatedPrincipal)object;
        String profileId = (String)principal.getAttribute("profileId");
        return (OAuth2AuthenticatedPrincipal)new DefaultOAuth2AuthenticatedPrincipal(profileId, principal.getAttributes(), (Collection)this.extractAuthorities(principal));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GrantedAuthority> extractAuthorities(OAuth2AuthenticatedPrincipal principal) {
        String scope;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List list = (List)principal.getAttribute("scope");
        List scopes = list == null ? CollectionsKt.emptyList() : list;
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("SCOPE_" + scope);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            scope = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SimpleGrantedAuthority((String)p0));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final OAuth2AuthenticatedPrincipal principalCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OAuth2AuthenticatedPrincipal)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ OpaqueTokenIntrospector access$getDelegate$p(JustOpaqueTokenIntrospector $this) {
        return $this.delegate;
    }
}

