/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.persistence.SubscriptionRepository;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/business/SubscriptionService;", "", "subscriptionRepository", "Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;", "(Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;)V", "read", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "setSubscription", "isSubscribed", "", "wiki-service"})
public class SubscriptionService {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public SubscriptionService(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, @NotNull ProfileId subscriber, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Subscription subscription = new Subscription(subscriber, itemId, isSubscribed);
        Object object = this.subscriptionRepository.save((Object)subscription);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"subscriptionRepository.save(subscription)");
        return SubscriptionDto.Companion.toDto((Subscription)object);
    }

    @NotNull
    public SubscriptionDto read(@NotNull ItemId itemId, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Subscription subscription = this.subscriptionRepository.findBySubscriberAndItemId(subscriber.getId(), itemId.getId());
        if (subscription == null) {
            subscription = new Subscription(subscriber, itemId, false);
        }
        return SubscriptionDto.Companion.toDto(subscription);
    }
}

