/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleVersionDto;
import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.graphql.generated.CreateArticleInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateArticleInput;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010)\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-*\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\fH\u0012J3\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H/01H\u0012\u00a2\u0006\u0002\u00102R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxPageSize", "", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;I)V", "countArticlesForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "input", "Lde/justsoftware/wikiservice/graphql/generated/CreateArticleInput;", "delete", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "deleteEditingToken", "", "read", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readArticleVersions", "Lde/justsoftware/wikiservice/business/model/ArticleVersionDto;", "articleIds", "readByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "readSubscribedArticles", "Lde/justsoftware/wikiservice/business/model/ArticleWithTitleDto;", "page", "size", "update", "Lde/justsoftware/wikiservice/graphql/generated/UpdateArticleInput;", "updateEditingToken", "toWikiIds", "", "withWriteCheck", "T", "block", "Lkotlin/Function1;", "(Lde/justsoftware/wikiservice/authorization/AuthContext;Lde/justsoftware/wikiservice/model/ArticleId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,181:1\n1#2:182\n125#3:183\n152#3,3:184\n125#3:198\n152#3,3:199\n1549#4:187\n1620#4,3:188\n483#5,7:191\n*S KotlinDebug\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n*L\n42#1:183\n42#1:184,3\n89#1:198\n89#1:199,3\n72#1:187\n72#1:188,3\n88#1:191,7\n*E\n"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;
    private final int maxPageSize;

    @Autowired
    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService, @Value(value="${service.maxPageSize:200}") int maxPageSize) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
        this.maxPageSize = maxPageSize;
    }

    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto it = articleDto = this.articleService.read(articleId);
        boolean bl = false;
        authContext.checkReadWiki(it.getWikiId());
        return articleDto;
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto it = articleDto = this.articleService.readArticleByVersionId(versionId);
        boolean bl = false;
        authContext.checkReadWiki(it.getWikiId());
        return articleDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, List<ArticleVersionDto>> readArticleVersions(@NotNull List<ArticleId> articleIds, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$map$iv = this.articleService.readByIds(CollectionsKt.toSet((Iterable)articleIds));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ArticleDto)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadArticleVersionHistory(wikiIds);
        return this.articleService.readVersions(CollectionsKt.toSet((Iterable)articleIds));
    }

    @NotNull
    public Map<ParentId, List<ArticleDto>> readByParentIds(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (parentIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Map map2;
            Map it = map2 = this.articleService.readByParentIds(CollectionsKt.toSet((Iterable)parentIds));
            boolean bl = false;
            authContext.checkReadWikis(this.toWikiIds(it));
            map = map2;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ArticleWithTitleDto> readSubscribedArticles(int page, int size, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!(page >= 0)) {
            boolean $i$a$-require-ArticleApplicationService$readSubscribedArticles$32 = false;
            String $i$a$-require-ArticleApplicationService$readSubscribedArticles$32 = "Page must not be < 0";
            throw new IllegalArgumentException($i$a$-require-ArticleApplicationService$readSubscribedArticles$32.toString());
        }
        if (!(1 <= size ? size <= this.maxPageSize : false)) {
            boolean $i$a$-require-ArticleApplicationService$readSubscribedArticles$42 = false;
            String $i$a$-require-ArticleApplicationService$readSubscribedArticles$42 = "PageSize must be between 1 and " + this.maxPageSize;
            throw new IllegalArgumentException($i$a$-require-ArticleApplicationService$readSubscribedArticles$42.toString());
        }
        List it = list = this.articleService.readBySubscriber(authContext.getUser(), page, size);
        boolean bl = false;
        Iterable iterable = it;
        AuthContext authContext2 = authContext;
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            ArticleWithTitleDto articleWithTitleDto = (ArticleWithTitleDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(a.getWikiId());
        }
        authContext2.checkReadWikis(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        return list;
    }

    @NotNull
    public Map<WikiId, Integer> countArticlesForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.articleService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Set<WikiId> toWikiIds(Map<ParentId, ? extends List<ArticleDto>> $this$toWikiIds) {
        void $this$mapTo$iv$iv;
        Map<ParentId, ? extends List<ArticleDto>> $this$filterValues$iv = $this$toWikiIds;
        boolean $i$f$filterValues = false;
        Map<ParentId, List<ArticleDto>> result$iv = new LinkedHashMap();
        for (Map.Entry<ParentId, ? extends List<ArticleDto>> entry$iv : $this$filterValues$iv.entrySet()) {
            List<ArticleDto> it = entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            if (!bl2) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ArticleDto)CollectionsKt.first((List)((List)it.getValue()))).getWikiId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public ArticleDto create(@NotNull CreateArticleInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = input.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        return this.articleService.create(parentId, wikiId, input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), position, input.getContactPerson());
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @NotNull UpdateArticleInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleDto article = this.articleService.read(articleId);
        if (input.getParentId() != null) {
            WikiId toWikiId = this.ancestorService.getAncestorWikiId(input.getParentId());
            authContext.checkMoveWikiContent(article.getWikiId(), toWikiId);
        } else {
            authContext.checkWriteWiki(article.getWikiId());
        }
        boolean articleWasMoved = this.ancestorService.moveArticle(articleId, input.getParentId(), authContext.getUser());
        return this.articleService.update(article.getId(), input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), input.getContactPerson(), articleWasMoved);
    }

    @Transactional
    @NotNull
    public ArticleDto delete(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (ArticleDto)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private <T> T withWriteCheck(AuthContext $this$withWriteCheck, ArticleId articleId, Function1<? super ArticleDto, ? extends T> block) {
        ArticleDto article = this.articleService.read(articleId);
        $this$withWriteCheck.checkWriteWiki(article.getWikiId());
        return (T)block.invoke((Object)article);
    }

    public static final /* synthetic */ DeletionService access$getDeletionService$p(ArticleApplicationService $this) {
        return $this.deletionService;
    }

    public static final /* synthetic */ ArticleService access$getArticleService$p(ArticleApplicationService $this) {
        return $this.articleService;
    }
}

