/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.PagingWidget;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediator;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiVersionBadgeWidget;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiVersionsView;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiVersionsViewImpl;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import javax.annotation.Nonnull;

public class WikiVersionsWidget
implements WikiVersionsView.Presenter {
    private static final int ITEMS_PER_PAGE = 10;
    private static final WikiEditorConstants WIKI_EDITOR = I18nMediator.WIKI_EDITOR;
    private static final WikiEditorMessages WIKI_EDITOR_MSG = I18nMediator.WIKI_EDITOR_MSG;
    private final WikiVersionsView _view;
    private final Label _header = new Label();
    private WikiEditorId _wikiEditorId = null;
    private WikiEditor _wikiEditor;
    private WikiVersionBadge _versionCompare1 = null;
    private WikiVersionBadge _versionCompare2 = null;
    private final PagingWidget<WikiVersionBadge> _pager = new PagingWidget(10, (String)null, (PagingWidget.PagingWidgetCreatePage)new /* Unavailable Anonymous Inner Class!! */);
    private final ClientFactory _clientFactory;

    public WikiVersionsWidget(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._view = new WikiVersionsViewImpl(clientFactory.eventManager(), (WikiVersionsView.Presenter)this);
        this._pager.setShowBottomPager(true);
        this._view.setVersionsPanel((IsWidget)this._pager);
    }

    public void compare() {
        WikiVersionBadge oldVer;
        WikiVersionBadge newVer;
        if (this._versionCompare1 == null || this._versionCompare2 == null) {
            WidgetUtil.showPopUp((int)1, (String)WIKI_EDITOR.pleaseSelectTwoVersions());
            return;
        }
        if (this._versionCompare1.getVersion() > this._versionCompare2.getVersion()) {
            newVer = this._versionCompare1;
            oldVer = this._versionCompare2;
        } else {
            newVer = this._versionCompare2;
            oldVer = this._versionCompare1;
        }
        WikiEditorMediator.getInstance().getWikiVersionDiff(oldVer.getId(), newVer.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void clearAll() {
        this._versionCompare1 = null;
        this._versionCompare2 = null;
        this._header.setText("");
        this._view.setHeader(null);
        this._view.setDiffContent("");
        this._view.showLegend(false);
    }

    public void setWikiEditor(WikiEditor wikiEditor) {
        this._wikiEditorId = wikiEditor.getId();
        this._wikiEditor = wikiEditor;
        this.clearAll();
        this._pager.updatePagingWidget();
    }

    public WikiEditorId getWikiEditorId() {
        return this._wikiEditorId;
    }

    void updateWikiVersionsWidget() {
        this.setWikiEditor(this._wikiEditor);
    }

    private void updateVersionRadioButtons() {
        for (IsWidget w : this._pager.getWidgetListPanel()) {
            ((WikiVersionBadgeWidget)w).updateVersionRadioButtons();
        }
    }

    public void showVersion(WikiVersionId wikiVersionId) {
        if (wikiVersionId == null) {
            this._view.setDiffContent("");
            this._view.setHeader(null);
            return;
        }
        WikiEditorMediator.getInstance().getWikiVersion(wikiVersionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public WikiVersionBadge getVersionCompare1() {
        return this._versionCompare1;
    }

    public void setVersionCompare1(WikiVersionBadge versionCompare1) {
        this._versionCompare1 = versionCompare1;
        this.updateVersionRadioButtons();
    }

    public WikiVersionBadge getVersionCompare2() {
        return this._versionCompare2;
    }

    public void setVersionCompare2(WikiVersionBadge versionCompare2) {
        this._versionCompare2 = versionCompare2;
        this.updateVersionRadioButtons();
    }

    public WikiEditor getWikiEditor() {
        return this._wikiEditor;
    }

    public WikiVersionsView getView() {
        return this._view;
    }
}

