/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.github.gwtbootstrap.client.ui.Form;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineActionFeedbackLabel;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyQuestionsWidget;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.SurveyQuestionId;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class SurveyQuestionsWidget
extends Composite {
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private static final SurveyMessages SURVEY_MSG = I18nMediator.SURVEY_MSG;
    private static final SurveyQuestionUIBinder SURVEY_QUESTION_UI_BINDER = (SurveyQuestionUIBinder)GWT.create(SurveyQuestionUIBinder.class);
    private static final SurveyQuestionsWidgetUIBinder SURVEY_QUESTION_WIDGET_UI_BINDER = (SurveyQuestionsWidgetUIBinder)GWT.create(SurveyQuestionsWidgetUIBinder.class);
    @UiField
    FlowPanel _questionsPanel;
    @UiField
    JCButton _submitButton;
    @UiField
    InlineActionFeedbackLabel _feedbackLabel;
    private SurveyTeaser _survey;
    private boolean _editable;
    private Map<SurveyQuestionId, List<DBSurveyParticipantAnswer>> _answersGroupByQuestions;
    private final ValidatorPanel.ValidatorPanelUtils _validatorPanelUtils;
    private final List<SurveyQuestion> _surveyQuestions = Lists.newArrayList();
    private final ClientFactory _clientFactory;
    private SurveyAnswersSaveSuccessHandler _surveyAnswersSaveSuccessHandler;

    public SurveyQuestionsWidget(SurveyTeaser survey, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        Form mainPanel = new Form();
        this.initWidget((Widget)mainPanel);
        this._survey = survey;
        if (!survey.getAllowedActions().contains((Object)StaticAction.SURVEY_READ)) {
            mainPanel.add((Widget)new Label(SURVEY.notAllowedToSeeSurvey()));
            this._editable = false;
            this._validatorPanelUtils = null;
            return;
        }
        this._validatorPanelUtils = new ValidatorPanel.ValidatorPanelUtils();
        this._editable = SurveyQuestionsWidget.isSurveyTeaserEditable((SurveyTeaser)this._survey);
        mainPanel.add((Widget)SURVEY_QUESTION_WIDGET_UI_BINDER.createAndBindUi((Object)this));
        this._answersGroupByQuestions = new HashMap(this._survey.getSurveyData().getQuestions().size());
        if (!CollectionUtil.isEmpty((Iterable)this._survey.getCurrentUserAnswers())) {
            for (DBSurveyParticipantAnswer answer : this._survey.getCurrentUserAnswers()) {
                ArrayList<DBSurveyParticipantAnswer> list = (ArrayList<DBSurveyParticipantAnswer>)this._answersGroupByQuestions.get(answer.getQuestionId());
                if (list == null) {
                    list = new ArrayList<DBSurveyParticipantAnswer>();
                    this._answersGroupByQuestions.put(answer.getQuestionId(), list);
                }
                list.add(answer);
            }
        }
        this._submitButton.setVisible(this._editable);
        this.addSurveyQuestions();
    }

    private void setEnabled(boolean enabled) {
        for (SurveyQuestion surveyQuestion : this._surveyQuestions) {
            surveyQuestion.setEnabled(enabled);
        }
    }

    private static boolean isSurveyTeaserEditable(SurveyTeaser surveyTeaser) {
        ImmutableSet allowedActions = surveyTeaser.getAllowedActions();
        boolean hasParticipated = !CollectionUtil.isEmpty((Iterable)surveyTeaser.getCurrentUserAnswers());
        return !surveyTeaser.isExpired() && (!hasParticipated && allowedActions.contains(StaticAction.SURVEY_PARTICIPATE) || allowedActions.contains(StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER));
    }

    private void addSurveyQuestions() {
        this._questionsPanel.clear();
        if (CollectionUtil.isEmpty((Iterable)this._survey.getSurveyData().getQuestions())) {
            this._questionsPanel.add((Widget)new Label(SURVEY.surveyNotPublished()));
            this._submitButton.setVisible(false);
            return;
        }
        for (DBSurveyQuestion question : this._survey.getSurveyData().getQuestions()) {
            SurveyQuestion surveyQuestion = new SurveyQuestion(this, question, (List)this._answersGroupByQuestions.get(question.getId()));
            surveyQuestion.setEnabled(this._editable);
            this._questionsPanel.add((Widget)surveyQuestion);
            this._surveyQuestions.add(surveyQuestion);
            this._validatorPanelUtils.addWrappedValidatable((Widget)surveyQuestion._answerPanelWrapper);
        }
    }

    @UiHandler(value={"_submitButton"})
    public void handleSubmit(ClickEvent event) {
        try {
            this._validatorPanelUtils.clearError();
            this._validatorPanelUtils.validate();
        }
        catch (ValidationException e) {
            return;
        }
        this._submitButton.setEnabled(false);
        this._feedbackLabel.showWaiting();
        ArrayList toSave = new ArrayList();
        for (SurveyQuestion surveyQuestion : this._surveyQuestions) {
            toSave.addAll(surveyQuestion.getAnswer());
        }
        this._clientFactory.surveyClientFactory().controller().saveSurveyParticipantAnswers(this._survey.getSurveyId(), toSave, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setSurveyAnswersSaveSuccessHandler(SurveyAnswersSaveSuccessHandler surveyAnswersSaveSuccessHandler) {
        this._surveyAnswersSaveSuccessHandler = surveyAnswersSaveSuccessHandler;
    }
}

