/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.survey.presentation.client.SurveyClientFactory;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyTeaserComponentWidget;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyListView;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyListViewImpl;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyTeaserView;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyTeaserViewImpl;
import de.justsoftware.onx.survey.presentation.shared.SurveyController;
import de.justsoftware.onx.survey.presentation.shared.SurveyControllerAsync;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.model.SurveyModuleData;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyClientFactoryImpl
implements SurveyClientFactory {
    private final SurveyControllerAsync _remoteService = (SurveyControllerAsync)GWT.create(SurveyController.class);
    private final ClientFactory _clientFactory;

    public SurveyClientFactoryImpl(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        UrlUtil.setRemoteServiceUrl((Object)this._remoteService, (String)"/survey");
    }

    public SurveyControllerAsync controller() {
        return this._remoteService;
    }

    public SurveyListView listView(SurveyListView.Presenter presenter) {
        return new SurveyListViewImpl(presenter, this._clientFactory.surveyClientFactory().i18nConstants());
    }

    public SurveyTeaserView teaserView() {
        return new SurveyTeaserViewImpl(this._clientFactory.dateFormatter());
    }

    public SurveyConstants i18nConstants() {
        return I18nMediator.SURVEY;
    }

    public void createSurveyTeaserComponentWidget(SurveyModuleData surveyModuleData, PlaceHolder placeHolder) {
        placeHolder.replace((IsWidget)new SurveyTeaserComponentWidget(surveyModuleData, this._clientFactory));
    }

    public void redirectToSurveyOnNewMembershipIfNecessary(EntityInfo parentEntity) {
        ClientEntityConfig config = this._clientFactory.getHostPropertiesBean().getClientEntityConfig((EntityType)parentEntity.getType());
        if (config != null && config.isRedirectToSurveyOnNewMemberEnabled()) {
            this._remoteService.getRedirectSurveyOnNewMembership((EntityId)parentEntity.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }
}

