/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.upload;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.server.upload.UploadedImageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class AlbumImageUploadHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AlbumImageUploadHelper.class);
    private final StorageServerHelper _storageServerHelper;
    private final AlbumService _albumService;
    private final ItemService _itemService;

    @Autowired
    public AlbumImageUploadHelper(StorageServerHelper storageServerHelper, AlbumService albumService, ItemService itemService) {
        this._storageServerHelper = storageServerHelper;
        this._albumService = albumService;
        this._itemService = itemService;
    }

    @Nonnull
    private UploadedImageInfo save(MultipartFile file, @Nullable AlbumId album, PersonId personId, boolean generateFeedMessage) throws ServiceException {
        InputStream in;
        String originalFilename = file.getOriginalFilename();
        String format = this._storageServerHelper.getFormatNameFromMultipartFile(file);
        try {
            in = file.getInputStream();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("AlbumImageUploadServlet: " + e.getMessage(), (Throwable)e);
        }
        SaveImageResult saveResult = this._albumService.uploadImage(in, format, personId, album, originalFilename);
        if (!saveResult.isOk()) {
            throw new ServiceException("AlbumImageUploadServlet: " + saveResult.getMessage());
        }
        String filename = saveResult.getFilename();
        if (filename == null) {
            throw new ServiceException("AlbumImageUploadServlet: no filename returned");
        }
        AlbumImageId newImageId = album != null ? this._albumService.insertDBImage(album, "", filename, personId, generateFeedMessage) : null;
        return new UploadedImageInfo(newImageId, saveResult.getWidth(), saveResult.getHeight(), filename, originalFilename);
    }

    @Nonnull
    public ImmutableList<UploadedImageInfo> saveImagesToAlbum(List<MultipartFile> files, AuthorizationCheckContextWithUserId authCtx, AlbumId albumId, boolean notifyOthers) throws PermissionDeniedException, NotLoggedInException, InvalidIDException {
        ImmutableList.Builder result = ImmutableList.builder();
        authCtx.check((ItemId)albumId, (Action)StaticAction.ALBUM_CREATE);
        for (MultipartFile f : files) {
            result.add((Object)this.save(f, albumId, authCtx.getUserId(), notifyOthers));
        }
        return result.build();
    }

    @Nonnull
    public ImmutableList<UploadedImageInfo> saveImagesToWorkstream(List<MultipartFile> files, AuthorizationCheckContextWithUserId authCtx, GlobalId parentId) throws PermissionDeniedException, NotLoggedInException, InvalidIDException {
        ImmutableList.Builder result = ImmutableList.builder();
        authCtx.check(this._itemService.getByIdNonNull((ItemId)parentId), (Action)StaticAction.WORKSTREAM_POST);
        for (MultipartFile f : files) {
            result.add((Object)this.save(f, null, authCtx.getUserId(), false));
        }
        return result.build();
    }
}

