/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.ArticleSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.ArticleSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WikiInfo;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ArticleSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    public ArticleSearchResultBadgePresenter(ClientFactory clientFactory, ArticleSearchResultBadgeModel model, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this.setIcon(model);
        this.setTitle(model);
        this.setParent(model);
        this._view.setParentEnabled(displayParents);
        this.setLastChangeDate(model.getModifyDate());
        this._view.addFoundIn((Collection)model.getFoundInFields(), (FieldNameResolver)ArticleFieldNameResolver.INSTANCE);
    }

    private void setTitle(ArticleSearchResultBadgeModel model) {
        String targetHistoryToken = this.token(model);
        String name = model.getName();
        if (name != null) {
            InlineHyperlink link = new InlineHyperlink(name, targetHistoryToken);
            link.setHTML(HTMLUtil.highlightedHtmlEscape((String)name));
            link.setTitle(HTMLUtil.removeHighlightTag((String)name));
            this._view.setTitleWidget(link);
        }
    }

    private void setParent(ArticleSearchResultBadgeModel model) {
        FlowPanel parentWidget = new FlowPanel();
        WikiInfo wikiInfo = model.getWikiInfo();
        if (wikiInfo != null) {
            InlineHyperlink link = new InlineHyperlink(wikiInfo.getWikiName(), "/wiki/wikis/" + wikiInfo.getWikiId());
            parentWidget.add((Widget)link);
            this._view.setParentWidget((Widget)parentWidget);
        }
    }

    @Nonnull
    private String token(ArticleSearchResultBadgeModel model) {
        return "/wiki/articles/" + model.getId();
    }

    private void setIcon(ArticleSearchResultBadgeModel model) {
        JCIconOnlyAnchor icon = new JCIconOnlyAnchor(IconType.FILE_TEXT, this.token(model));
        icon.addStyleName("action");
        icon.addStyleName("badgeIcon");
        icon.addStyleName("app-wiki-color");
        icon.setTitle(HTMLUtil.removeHighlightTag((String)model.getName()));
        this._view.setIconWidget((Widget)icon);
    }
}

