/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.freiheit.toro.common.shared.i18n.SearchProviderConstants;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.i18n.dynamic.client.AbstractDynamicI18n;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedView;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedViewImpl;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.search.presentation.client.ui.ReactSearchFilterEditPageWidget;
import de.justsoftware.onx.search.presentation.client.ui.SearchResultPageWidget;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.CommonSearchMediator;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.SearchResultPage;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterView;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchBadgeOverlayView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchBadgeOverlayViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterCallback;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterListView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterListViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterToggleAnchorView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterToggleDropdownTabView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterToggleView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeaderView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeaderViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlinePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlineView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlineWidget;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchPanelView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchPanelViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultHeaderView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultHeaderViewImpl;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultPageView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionFilterView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionFilterViewImpl;
import de.justsoftware.onx.searchnew.presentation.shared.CommonSearchRemoteServiceAsync;
import de.justsoftware.onx.searchnew.presentation.shared.SearchController;
import de.justsoftware.onx.searchnew.presentation.shared.SearchControllerAsync;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class SearchClientFactoryImpl
implements SearchClientFactory {
    private final SearchControllerAsync _controller;
    private final Map<SearchProviderId, SearchProviderConstants> _providerMessagesMap = Maps.newHashMap();
    private final ClientFactory _clientFactory;
    private final AtomicBoolean _forceNewSearch = new AtomicBoolean(false);
    private ImmutableList<SearchProvider> _searchProviderList;

    public SearchClientFactoryImpl(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._controller = (SearchControllerAsync)GWT.create(SearchController.class);
        UrlUtil.setRemoteServiceUrl((Object)this._controller, (String)"/searchController");
    }

    public SearchControllerAsync controller() {
        return this._controller;
    }

    public CommonSearchRemoteServiceAsync commonSearchService() {
        return CommonSearchMediator.getInstance();
    }

    public void getAvailableSearchProvider(AsyncCallback<ImmutableList<SearchProvider>> callbackWithProviders) {
        if (this._searchProviderList != null) {
            callbackWithProviders.onSuccess((Object)this._searchProviderList);
            return;
        }
        this._controller.getAvailableSearchProvider((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public SearchProviderConstants getProviderMessages(SearchProviderId providerId) {
        SearchProviderConstants constants = (SearchProviderConstants)this._providerMessagesMap.get(providerId);
        if (constants == null) {
            constants = this.generateProviderMessages(providerId);
            if (constants == null) {
                throw new NullPointerException("SearchProviderConstants must not be null");
            }
            this._providerMessagesMap.put(providerId, constants);
        }
        return constants;
    }

    @Nonnull
    private SearchProviderConstants generateProviderMessages(@Nonnull SearchProviderId providerId) {
        SearchProviderConstants dynamicMessages = (SearchProviderConstants)GWT.create(SearchProviderConstants.class);
        ((AbstractDynamicI18n)dynamicMessages).setKeyPrefix(providerId.getId());
        return dynamicMessages;
    }

    public SearchConstants getSearchConstants() {
        return I18nMediator.SEARCH;
    }

    public <T> SingleSelectionFilterView<T> getSingleSelectionFilterView(SingleSelectionFilterView.Presenter<T> presenter) {
        return new SingleSelectionFilterViewImpl(presenter);
    }

    public <T> MultipleSelectionFilterView<T> getMultipleSelectionSubFilterView(MultipleSelectionFilterView.Presenter<T> presenter) {
        return new MultipleSelectionFilterViewImpl(presenter, this._clientFactory.commonClientFactory());
    }

    public SearchHeadlineView createSearchHeadlineView() {
        return new SearchHeadlineWidget();
    }

    public SearchHeadlineView.Presenter createSearchHeadlinePresenter() {
        return new SearchHeadlinePresenter((SearchClientFactory)this);
    }

    public SearchResultBadgeView getSearchResultBadgeView(SearchResultBadgeView.Presenter presenter, boolean withContextSwitch, String additionalOverlayStyleName) {
        return new SearchResultBadgeViewImpl(this._clientFactory, presenter, withContextSwitch, additionalOverlayStyleName);
    }

    public SearchResultHeaderView createSearchResultHeaderView(SearchResultHeaderView.Presenter presenter, boolean showParentColumn, boolean hasContextSwitch) {
        return new SearchResultHeaderViewImpl(presenter, showParentColumn, hasContextSwitch);
    }

    public TabbedView getSearchFilterTabsView(TabbedView.Presenter presenter, SearchFilterToggleView.Presenter searchFilterToggle) {
        return new TabbedViewImpl(5, "search-filter-tabs", presenter, searchFilterToggle);
    }

    public SearchFilterListView getSubfilterListView(SearchFilterListView.Presenter presenter) {
        return new SearchFilterListViewImpl(presenter);
    }

    public SearchConfigurationProvider searchConfigurationProvider() {
        return ClientSearchConfigurationProvider.INSTANCE;
    }

    public void newSearchHistoryItem(SearchParameters searchParameters) {
        History.newItem((String)SearchHandler.tokenFor((SearchParameters)searchParameters));
    }

    public SearchInputView createSearchInputView(SearchInputView.Presenter presenter, String trackingContext) {
        return new SearchInputViewImpl(this._clientFactory, presenter, trackingContext);
    }

    public SearchInputView.Presenter createSearchInputPresenter(boolean showSaveSearchFilterMenu, String trackingContext) {
        return new SearchInputPresenter(this._clientFactory, showSaveSearchFilterMenu, trackingContext);
    }

    public SearchHeaderView createSearchHeaderView(String entryToken) {
        return new SearchHeaderViewImpl(entryToken);
    }

    public SearchPanelView createSearchPanelView() {
        return new SearchPanelViewImpl();
    }

    public SearchBadgeOverlayView createSearchBadgeOverlayView(String additionalStyleName) {
        return new SearchBadgeOverlayViewImpl(additionalStyleName);
    }

    public SearchResultWidget createSearchResultWidget(SearchParameters searchParameters, SearchFilterCallback searchFilterCallback, String additionalOverlayStyleName) {
        return new SearchResultWidget(this._clientFactory, searchParameters, searchFilterCallback, null, additionalOverlayStyleName);
    }

    public SearchFilterToggleAnchorView createSearchFilterToggleAnchorView() {
        return new SearchFilterToggleAnchorView();
    }

    public SearchFilterToggleDropdownTabView createSearchFilterToggleDropdownTabView() {
        return new SearchFilterToggleDropdownTabView();
    }

    public boolean getAndSetForceNewSearch(boolean forceNewSearch) {
        return this._forceNewSearch.getAndSet(forceNewSearch);
    }

    public String historyTokenFor(SearchParameters searchParams) {
        return SearchHandler.tokenFor((SearchParameters)searchParams);
    }

    public SearchResultPageView.Presenter createSearchResultPagePresenter() {
        return new SearchResultPageWidget(this._clientFactory);
    }

    public SearchResultPageView.Presenter createOldSearchResultPagePresenter(SearchParameters searchParameters, String entryToken) {
        return new SearchResultPage(searchParameters, this._clientFactory, entryToken);
    }

    public SearchResultPageView.Presenter createSearchFilterEditPagePresenter() {
        return new ReactSearchFilterEditPageWidget();
    }

    public void getOrderedSearchFilterTypes(AsyncCallback<ImmutableSet<FilterType>> filterTypeCallback) {
        this._controller.getOrderedSearchFilterTypes(filterTypeCallback);
    }
}

