/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.server;

import com.freiheit.toro.account.shared.model.WrongPasswordException;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.auditing.shared.AuditSensitive;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.presentation.server.JucoLocaleResolver;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.ValidationResult;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.business.AccountSettingsService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonValidator;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.presentation.shared.PersonController;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonPopupModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.settings.ProfileSettings;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.security.service.MobileLogoutService;
import java.util.List;
import java.util.Set;
import org.gwtwidgets.server.spring.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PersonControllerImpl
implements PersonController {
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    @Qualifier(value="personValidator")
    private PersonValidator _personValidator;
    @Autowired
    private AccountSettingsService _accountSettingsService;
    @Autowired
    private JucoLocaleResolver _localeResolver;
    @Autowired
    private FrontendLoginService _frontendLoginService;
    @Autowired
    private PasswordEncoder _passwordEncoder;
    @Autowired
    private MobileLogoutService _mobileLogoutService;

    public PersonDetailsModel getPersonDetailsModelById(PersonId personId) {
        if (personId == null) {
            throw new ServiceException("personId must not be null!");
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            return this._profileTeaserService.getPersonDetailsModelById(personId, (SearchAuthorizationCheckContext)authorizationContext);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
    }

    public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserModelsByIds(ImmutableSet<PersonId> ids) {
        return this._profileTeaserService.getPersonTeasersByIds(ids, (AuthorizationCheckContextWithLocale)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public PersonTeaserModel getPersonTeaserModelById(PersonId id) {
        return (PersonTeaserModel)this.getPersonTeaserModelsByIds(ImmutableSet.of((Object)id)).get((Object)id);
    }

    public void deleteAccountAsSuperadmin(PersonId personId) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._personService.deleteOtherPerson(personId, (AuthorizationCheckContextWithUserId)auth);
        if (auth.getUserId().equals((Object)personId)) {
            this._frontendLoginService.logout(ServletUtils.getRequest(), ServletUtils.getResponse());
        }
    }

    public void deleteAccount(@AuditSensitive String password) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        DBPerson user = this._personService.getPersonById(auth.getUserId());
        if (user == null) {
            throw new InvalidIdServiceException();
        }
        if (!this._passwordEncoder.matches((CharSequence)password, user.getPasswordHash())) {
            throw new WrongPasswordException();
        }
        this._personService.deleteOwnPerson((AuthorizationCheckContextWithUserId)auth);
        this._frontendLoginService.logout(ServletUtils.getRequest(), ServletUtils.getResponse());
    }

    public void changeLanguageForLoggedInUser(String languageCode) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._personService.changeLanguageForUser(auth.getUserId(), languageCode);
        this._localeResolver.setLanguage(ServletUtils.getRequest(), ServletUtils.getResponse(), languageCode);
    }

    public DBAccountSettings updateOwnEmailAddress(String newEmail, String password) throws ValidatableException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._accountSettingsService.updateOwnEmailAddress(newEmail, password, (AuthorizationCheckContextWithUserId)authCtx);
        return this._personService.getAccountSettingsByPersonId(authCtx.getUserId());
    }

    public DBAccountSettings updateEmailAddressForDifferentUser(PersonId affectedPerson, String newEmail) throws ValidatableException {
        this._accountSettingsService.updateEmailAddressForDifferentUser(affectedPerson, newEmail, (AuthorizationCheckContext)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
        return this._personService.getAccountSettingsByPersonId(affectedPerson);
    }

    public DBAccountSettings updateOwnPassword(String newPassword, String oldPassword) throws ValidatableException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._accountSettingsService.updateOwnPassword(newPassword, oldPassword, (AuthorizationCheckContextWithUserId)authCtx);
        return this._personService.getAccountSettingsByPersonId(authCtx.getUserId());
    }

    public DBAccountSettings updatePasswordForDifferentUser(PersonId affectedPerson, String newPassword) throws ValidatableException {
        this._accountSettingsService.updatePasswordForDifferentUser(affectedPerson, newPassword, (AuthorizationCheckContext)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
        return this._personService.getAccountSettingsByPersonId(affectedPerson);
    }

    public void updateEmailNotificationSettings(EmailNotificationSettingsBean emailNotificationSettingsBean) {
        PersonId userId = emailNotificationSettingsBean.getPersonId();
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        DBPerson personById = this._personService.getPersonById(userId);
        if (personById == null) {
            throw new InvalidIdServiceException();
        }
        this._personService.saveEmailNotificationSettings(new DBEmailNotificationSettings(userId, (EmailNotificationSettings)emailNotificationSettingsBean), emailNotificationSettingsBean.isChatEmailNotificationEnabled(), (AuthorizationCheckContext)auth);
    }

    public DBAccountSettings getAccountSettings(PersonId personId) {
        this._authorizationContextProvider.getAuthorizationContextForCurrentUser().check((ItemId)ProfileId.valueOf((PersonId)personId), (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        return this._personService.getAccountSettingsByPersonId(personId);
    }

    public List<ValidationResult> validatePassword(@AuditSensitive String password) {
        return this._personValidator.validatePassword(password);
    }

    public EmailNotificationSettingsBean getEmailNotificationSettings(PersonId personId) {
        this._authorizationContextProvider.getAuthorizationContextForCurrentUser().check((ItemId)ProfileId.valueOf((PersonId)personId), (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        return (EmailNotificationSettingsBean)this._personService.getEmailNotificationSettingsByPersonIds((Set)Sets.newHashSet((Object[])new PersonId[]{personId})).get(personId);
    }

    public ProfileSettings getProfileSettings(PersonId personId) {
        ProfileItem profileItem = (ProfileItem)InvalidIdServiceException.check((Object)this._personService.getProfileItemByPersonId(personId));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)profileItem, (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        ImmutableSet may = authorizationContext.may((Item)profileItem, ImmutableSet.of((Object)StaticAction.PERSON_DELETE));
        ProfileSettings profileSettingsModel = new ProfileSettings(may);
        String email = profileItem.getPerson().getEmail();
        EmailNotificationSettingsBean settings = this.getEmailNotificationSettings(personId);
        boolean showEmailNotificationSection = settings != null && settings.isEmailNotificationsVisible();
        profileSettingsModel.setDisplayEmailNotificationSection(showEmailNotificationSection);
        profileSettingsModel.setEmail(email);
        profileSettingsModel.setMobileDevicesCount(this._mobileLogoutService.countMobileLogins(personId));
        return profileSettingsModel;
    }

    public void setPersonBlocked(PersonId personId, boolean block) throws ValidatableException {
        this._personService.setPersonBlocked(personId, block, (AuthorizationCheckContext)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void setActivated(PersonId personId, boolean activated) throws ServiceException {
        this._personService.setAccountActivated(personId, activated, (AuthorizationCheckContext)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public PersonPopupModel getPersonPopupModelById(PersonId personId, ImmutableSet<? extends Action> requiredActions) {
        return (PersonPopupModel)this._profileTeaserService.getPersonPopupModelsByIds(ImmutableSet.of((Object)personId), requiredActions, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser()).get((Object)personId);
    }
}

