/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.components.presentation.client.ui.HolmesService;
import de.justsoftware.onx.context.PowerBarContext;
import de.justsoftware.onx.person.presentation.client.AccountSettingsSectionPresenter;
import de.justsoftware.onx.person.presentation.client.PersonClientFactory;
import de.justsoftware.onx.person.presentation.client.ui.PowerBarAccountSettingsView;
import de.justsoftware.onx.person.presentation.shared.PersonSettingsControllerAsync;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PowerBarSelectionPresenter
implements PowerBarAccountSettingsView.PowerBarAccountSettingsViewPresenter {
    private final PowerBarAccountSettingsView _view;
    private final AccountSettingsSectionPresenter _parentPresenter;
    private final PersonSettingsControllerAsync _personSettingsController;
    private final PowerBarContext _powerBarContext;
    private final HolmesService _holmesService;
    private boolean _initialPowerBarValue;

    public PowerBarSelectionPresenter(AccountSettingsSectionPresenter parentSectionPresenter, PersonClientFactory personClientFactory, HolmesService holmesService, PowerBarContext powerBarContext) {
        this._parentPresenter = parentSectionPresenter;
        this._powerBarContext = powerBarContext;
        this._view = personClientFactory.powerBarAccountSettingsView((PowerBarAccountSettingsView.PowerBarAccountSettingsViewPresenter)this);
        this._personSettingsController = personClientFactory.personSettingsController();
        this._holmesService = holmesService;
        this._initialPowerBarValue = this._powerBarContext.isPowerBarEnabled();
        this._view.setPowerBarSetting(this._initialPowerBarValue);
    }

    @Nonnull
    public IsWidget getView() {
        return this._view;
    }

    public void onSave(AsyncCallback<Void> callback) {
        boolean newPowerBarState = this._view.getPowerBarSetting();
        this._personSettingsController.setPowerBarSetting(newPowerBarState, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onOptionsChange(boolean isUsing) {
        this._parentPresenter.enableSaveButton(isUsing != this._initialPowerBarValue);
    }

    private void togglePowerBarState() {
        this._initialPowerBarValue = !this._initialPowerBarValue;
        this._parentPresenter.enableSaveButton(false);
    }
}

