/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.server;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.ListAndCountAndIndex;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActionsDetails;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.presentation.shared.LikeController;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LikeControllerImpl
implements LikeController {
    @Autowired
    private LikeService _likeService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;

    public FailedAndSuccessfulActionsDetails<ItemId, SubscriptionStatus> setSubscriptionsState(ImmutableSet<ItemId> ids, SubscriptionState state) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._likeService.setSubscriptionState(ids, state, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public LikeStatus setLikeAndSubscription(ItemId id, boolean like) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._likeService.setLikeAndSubscription(id, like, (AuthorizationCheckContextWithUserId)authorizationContext);
        return (LikeStatus)this._likeService.getLikes((Iterable)ImmutableSet.of((Object)id), (AuthorizationCheckContextWithUserId)authorizationContext).get((Object)id);
    }

    public Map<ItemId, LikeStatus> getLikes(ImmutableSet<ItemId> ids) throws NotLoggedInException {
        return this._likeService.getLikes(ids, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public LikeStatus getLike(ItemId id) {
        return (LikeStatus)this.getLikes(ImmutableSet.of((Object)id)).get(id);
    }

    public ListAndCountAndIndex<PersonTeaserModel> getAllLikers(ItemId id, int offset, int limit) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._likeService.getAllLikers(id, offset, limit, (AuthorizationCheckContextWithLocale)authorizationContext);
    }
}

