/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.version;

import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.github.gwtbootstrap.client.ui.Column;
import com.github.gwtbootstrap.client.ui.Popover;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.google.common.collect.ImmutableList;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareRowView;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareRowViewImpl;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.Nonnull;

public class EntityVersionCompareRowViewImpl
implements EntityVersionCompareRowView {
    private static final EntityVersionCompareRowViewBinder BINDER = (EntityVersionCompareRowViewBinder)GWT.create(EntityVersionCompareRowViewBinder.class);
    @UiField
    RadioButton _radio1;
    @UiField
    RadioButton _radio2;
    @UiField
    Anchor _version;
    @UiField
    HTMLPanel _reviewer;
    @UiField
    Column _authorColumn;
    @UiField
    Popover _changeMessage;
    @UiField
    IconAnchor _infoAnchor;
    @UiField
    IconAnchor _deleteAnchor;
    @UiField
    IconAnchor _restoreAnchor;
    @UiField
    Column _timestampColumn;
    private final Row _versionRow = (Row)BINDER.createAndBindUi((Object)this);
    private final EntityVersionCompareRowView.Presenter _parent;

    public EntityVersionCompareRowViewImpl(@Nonnull EntityVersionCompareRowView.Presenter presenter) {
        this._parent = presenter;
    }

    public Widget asWidget() {
        return this._versionRow;
    }

    public void setVersionString(String versionString) {
        this._version.setText(versionString);
    }

    public void checkRadio1(boolean checked) {
        this._radio1.setValue(Boolean.valueOf(checked));
    }

    public void checkRadio2(boolean checked) {
        this._radio2.setValue(Boolean.valueOf(checked));
    }

    public void setRadio1Enabled(boolean enabled) {
        this._radio1.setEnabled(enabled);
    }

    public void setRadio2Enabled(boolean enabled) {
        this._radio2.setEnabled(enabled);
    }

    public void setAuthor(PersonTeaserModel author) {
        this._authorColumn.clear();
        this._authorColumn.add(PersonUtil.profileLink((String)author.getFullName(), (PersonTeaserModel)author));
    }

    public void setChangeMessage(String changeMessage) {
        this._changeMessage.setText(changeMessage);
    }

    public void setInfoButtonVisible(boolean visible) {
        this.setCssVisibility(this._infoAnchor, visible);
    }

    public void setChangeMessageVisible(boolean visible) {
    }

    public void setReviewer(ImmutableList<PersonTeaserModel> reviewers) {
        this._reviewer.clear();
        for (PersonTeaserModel person : reviewers) {
            HTMLPanel liPanel = new HTMLPanel("li", "");
            liPanel.add(PersonUtil.profileLink((String)person.getFullName(), (PersonTeaserModel)person));
            this._reviewer.add((Widget)liPanel);
        }
    }

    public void setCreationDate(String formatedDate) {
        this._timestampColumn.clear();
        if (formatedDate != null) {
            this._timestampColumn.add((Widget)new Label(formatedDate));
        }
    }

    public void setDeleteButtonVisible(boolean visible) {
        this.setCssVisibility(this._deleteAnchor, visible);
    }

    public void setRestoreButtonVisible(boolean visible) {
        this.setCssVisibility(this._restoreAnchor, visible);
    }

    @UiHandler(value={"_radio1"})
    public void handleCheckFirst(@Nonnull ClickEvent event) {
        this._parent.setSelectedAsFirstVersion(true);
    }

    @UiHandler(value={"_radio2"})
    public void handleCheckSecond(@Nonnull ClickEvent event) {
        this._parent.setSelectedAsSecondVersion(true);
    }

    @UiHandler(value={"_version"})
    public void handleVersionClicked(@Nonnull ClickEvent event) {
        this._parent.setVersionClicked();
    }

    @UiHandler(value={"_radio1"})
    public void handleRadio1Changed(@Nonnull ValueChangeEvent<Boolean> event) {
        this._parent.setSelectedAsFirstVersion(this._radio1.getValue().booleanValue());
    }

    @UiHandler(value={"_radio2"})
    public void handleRadio2Changed(@Nonnull ValueChangeEvent<Boolean> event) {
        this._parent.setSelectedAsSecondVersion(this._radio2.getValue().booleanValue());
    }

    @UiHandler(value={"_deleteAnchor"})
    public void handleDelete(@Nonnull ClickEvent event) {
        this._parent.deleteVersionClicked();
    }

    @UiHandler(value={"_restoreAnchor"})
    public void handleRestore(@Nonnull ClickEvent event) {
        this._parent.restoreVersionClicked();
    }

    private void setCssVisibility(@Nonnull IconAnchor icon, boolean visible) {
        icon.setStyleName("invisible", !visible);
    }
}

