/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.navigator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorView;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorViewImpl;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityNavigatorPresenter
implements EntityNavigatorView.Presenter {
    private final ClientFactory _clientFactory;
    private final EntityNavigatorView _view;
    private final EntityInfo _entity;

    public EntityNavigatorPresenter(ClientFactory clientFactory, EntityInfo entity, @Nullable SearchParameters searchParameters) {
        this._clientFactory = clientFactory;
        this._entity = entity;
        ClientEntityConfig config = this._clientFactory.entityFactory().entityConfig((EntityType)this._entity.getType());
        ImmutableSet navigatorFilterTypes = config.getHierarchyFilterTypes();
        SearchParameters parameters = this.createParameters(searchParameters);
        this._view = new EntityNavigatorViewImpl(this._clientFactory, parameters, navigatorFilterTypes, entity);
    }

    public EntityNavigatorView getView() {
        return this._view;
    }

    @Nonnull
    private SearchParameters createParameters(@Nullable SearchParameters params) {
        ClientEntityConfig config = this._clientFactory.entityFactory().entityConfig((EntityType)this._entity.getType());
        ImmutableSet navigatorFilterTypes = config.getHierarchyFilterTypes();
        FilterType defaultFilter = (FilterType)Iterables.getFirst((Iterable)navigatorFilterTypes, null);
        SortType defaultSortType = config.getNavigatorSortType();
        if (params == null) {
            return new SearchParameters("", defaultFilter, SearchContext.ENTITY, (GlobalId)this._entity.getId(), null, defaultSortType, null, SearchProviderId.JUCO_ID, (SearchFacetParameters)StaticSearchFacetParameters.DEFAULT_FACETS, true, (EntityType)this._entity.getType()).withDefaultSubfilter(ClientSearchConfigurationProvider.INSTANCE).withHistoryToken(HistoryToken.ENTITY);
        }
        SearchParameters result = params;
        if (result.getFilterType() == null) {
            result = result.withFilter(defaultFilter);
        }
        if (result.getSortType() == null) {
            result = result.withSortType(defaultSortType);
        }
        return result.isNavigatorSearch(true).withNavigatorRootEntityType((EntityType)this._entity.getType());
    }

    public void onSearchParametersChanged(SearchParameters newParameters) {
        SearchParameters parameters = this.createParameters(newParameters);
        this._view.onSearchParametersChanged(parameters);
    }
}

