/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.navigator;

import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.google.common.collect.ImmutableList;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbView;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityNavigatorBreadcrumbViewImpl
extends Composite
implements EntityNavigatorBreadcrumbView {
    private final FlowPanel _container = new FlowPanel();
    private final UnorderedList _breadcrumbItems = new UnorderedList();
    private final EntityId _entityId;
    private final SearchParameters _searchParameters;
    private EntityNavigatorBreadcrumbView.ContextHierarchyItem _contextEntity;
    private ImmutableList<EntityNavigatorBreadcrumbView.ContextHierarchyItem> _contextHierarchy;

    public EntityNavigatorBreadcrumbViewImpl(EntityId entityId, SearchParameters searchParameters) {
        this._entityId = entityId;
        this._searchParameters = searchParameters;
        this._breadcrumbItems.addStyleName("entity-navigator-breadcrumb");
        this._container.add((Widget)this._breadcrumbItems);
        this._container.addStyleName("entity-navigator-breadcrumb-container");
        this.initWidget((Widget)this._container);
        this.setVisible(false);
    }

    private void createBreadcrumbItems() {
        this._breadcrumbItems.clear();
        ImmutableList.Builder contextHierarchyForLink = ImmutableList.builder();
        for (EntityNavigatorBreadcrumbView.ContextHierarchyItem hierarchyItem : this._contextHierarchy) {
            this.addBreadcrumbItem(hierarchyItem, contextHierarchyForLink.build());
            contextHierarchyForLink.add((Object)hierarchyItem.getEntityId());
        }
        Hyperlink contextEntityLink = new Hyperlink(this._contextEntity.getEntityName(), EntityOverviewHandler.token((EntityId)this._contextEntity.getEntityId()));
        contextEntityLink.setTitle(this._contextEntity.getEntityName());
        this.addBreadcrumbWidget((Widget)contextEntityLink);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void addBreadcrumbItem(EntityNavigatorBreadcrumbView.ContextHierarchyItem hierarchyItem, ImmutableList<EntityId> contextHierarchy) {
        Label widget;
        if (hierarchyItem.isVisible()) {
            String historyToken = EntityOverviewHandler.token((EntityId)this._entityId, (EntityTab)StaticEntityTab.HIERARCHY, (SearchParameters)this._searchParameters.withEntityId(hierarchyItem.getEntityId()).withContextHierarchy(contextHierarchy));
            widget = new Hyperlink(hierarchyItem.getEntityName(), historyToken);
        } else {
            widget = new Label(hierarchyItem.getEntityName());
        }
        widget.setTitle(hierarchyItem.getEntityName());
        this.addBreadcrumbWidget((Widget)widget);
    }

    private void addBreadcrumbWidget(Widget widget) {
        ListItem item = new ListItem(new Widget[]{widget});
        item.addStyleName("entity-navigator-breadcrumb-item");
        this._breadcrumbItems.add((Widget)item);
    }

    public void onContextChanged(EntityNavigatorBreadcrumbView.ContextHierarchyItem contextEntity, ImmutableList<EntityNavigatorBreadcrumbView.ContextHierarchyItem> contextHierarchy) {
        EntityId currentContextEntityId;
        EntityId entityId = currentContextEntityId = this._contextEntity != null ? this._contextEntity.getEntityId() : null;
        if (contextEntity.getEntityId().equals((Object)currentContextEntityId) && contextHierarchy.equals((Object)this._contextHierarchy)) {
            return;
        }
        this._contextEntity = contextEntity;
        this._contextHierarchy = contextHierarchy;
        this.createBreadcrumbItems();
    }
}

