/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.DataSuggestion;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCSuggestBox;
import de.justsoftware.onx.common.presentation.client.ui.TextBoxWithDescription;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.OnSuggestionSelectHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntitySelectWidget;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.EntitySolrSuggestOracle;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntitySelectWidget
extends CompositePanelWithValue<EntityId>
implements Validatable {
    private final Set<EntityType> _suggestTypes;
    private final SuggestBox _suggestBox;
    private final TextBoxWithDescription _suggestTextBoxWidget;
    private final InlineFeedbackWidget _inlineFeedbackWidget = new InlineFeedbackWidget();
    private EntitySuggest _lastSelectedSuggest = null;
    private boolean _displayErrorInlineWhileValidation = false;
    private final EntityTypeAheadSelectValidator _validator;
    private DataSuggestion<EntitySuggest> _typeAheadSelectedEntity;
    private final List<OnSuggestionSelectHandler> _selectHandler = new ArrayList();
    private EntitySolrSuggestOracle _entitySolrSuggestOracle;

    public EntitySelectWidget(Set<EntityType> types, @Nullable String popupStyle) {
        this(types, null, popupStyle);
    }

    public EntitySelectWidget(Set<EntityType> suggestTypes, EntityTypeAheadSelectValidator validator) {
        this(suggestTypes, validator, "entity-select-suggest-popup");
    }

    public EntitySelectWidget(Set<EntityType> suggestTypes, EntityTypeAheadSelectValidator validator, @Nullable String popupStyle) {
        if (suggestTypes.isEmpty()) {
            throw new IllegalArgumentException("Set of EntityTypes must not be emtpy.");
        }
        this._suggestTypes = suggestTypes;
        this._validator = validator;
        this._suggestTextBoxWidget = new TextBoxWithDescription();
        this._entitySolrSuggestOracle = new EntitySolrSuggestOracle(ImmutableSet.copyOf((Collection)this._suggestTypes), this._validator);
        this._suggestBox = new JCSuggestBox((SuggestOracle)this._entitySolrSuggestOracle, (ValueBoxBase)this._suggestTextBoxWidget, popupStyle);
        this._suggestBox.setStyleName("gwt-TextBox");
        this._suggestBox.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._suggestBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this._suggestBox);
        this.add((Widget)this._inlineFeedbackWidget);
        this._suggestTextBoxWidget.setDescriptionText(this.getSuggestTextBoxDescriptionText());
    }

    @Nonnull
    private String getSuggestTextBoxDescriptionText() {
        if (this._suggestTypes.size() == 1) {
            EntityType onlyElement = (EntityType)Iterables.getOnlyElement((Iterable)this._suggestTypes);
            return I18nMediator.getEntityConstantsByEntityType((EntityType)onlyElement).enterNameOfEntityHere(onlyElement);
        }
        return I18nMediator.BASIC_CONSTANTS.name();
    }

    protected void setValue(EntityId oldValue, EntityId newValue, boolean fireEvents) {
        this._lastSelectedSuggest = null;
        this._suggestTextBoxWidget.setValue((Object)"");
        super.setValue((Object)oldValue, (Object)newValue, fireEvents);
    }

    public void initValue(@Nonnull EntityInfo entityTeaser) {
        this._lastSelectedSuggest = null;
        this._suggestBox.setValue(entityTeaser.getName(), false);
        super.setValue((Object)((EntityId)this.getValue()), (Object)((EntityId)entityTeaser.getId()), false);
    }

    public void clearError() {
        this._inlineFeedbackWidget.hide();
    }

    public void displayErrorMessage(String errorMessage) {
        this._inlineFeedbackWidget.setMessage(errorMessage);
        this._inlineFeedbackWidget.show(InlineFeedbackWidget.InlineType.ERROR);
    }

    public void validate() throws ValidationException {
        this.clearError();
        if (this._lastSelectedSuggest == null && this.getValue() == null && !StringUtil.isBlank((String)this._suggestBox.getValue())) {
            throw this.selectASuggestedItemError();
        }
        if (this._lastSelectedSuggest != null && this.getValue() != null && !this._suggestBox.getValue().equals(this._lastSelectedSuggest.getName())) {
            throw this.selectASuggestedItemError();
        }
    }

    @Nonnull
    private ValidationException selectASuggestedItemError() {
        String selectASuggestedItem = I18nMediator.BASIC_CONSTANTS.pleaseSelectASuggestedItem();
        if (this._displayErrorInlineWhileValidation) {
            this.displayErrorMessage(selectASuggestedItem);
        }
        return new ValidationException(selectASuggestedItem);
    }

    public void setDisplayErrorInlineWhileValidation(boolean displayErrorInlineWhileValidation) {
        this._displayErrorInlineWhileValidation = displayErrorInlineWhileValidation;
    }

    public boolean isDisplayErrorInlineWhileValidation() {
        return this._displayErrorInlineWhileValidation;
    }

    public String getText() {
        return this._suggestBox.getText();
    }

    public void addOnSuggestionSelectHandler(OnSuggestionSelectHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._selectHandler.add(handler);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this._suggestBox.setWidth(width);
    }

    public void setText(String text) {
        this._suggestBox.setText(text);
    }

    public void setFocus(boolean focused) {
        this._suggestBox.setFocus(focused);
    }

    public void setEnabled(boolean enabled) {
        this._suggestBox.setEnabled(enabled);
    }

    static /* synthetic */ void access$001(EntitySelectWidget x0, Object x1, Object x2, boolean x3) {
        super.setValue(x1, x2, x3);
    }

    static /* synthetic */ void access$101(EntitySelectWidget x0, Object x1, Object x2, boolean x3) {
        super.setValue(x1, x2, x3);
    }

    static /* synthetic */ void access$201(EntitySelectWidget x0, Object x1, Object x2, boolean x3) {
        super.setValue(x1, x2, x3);
    }
}

