/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.ParentEntityConfig;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.EntityParentSelectPermissonValidator;
import de.justsoftware.onx.container.presentation.client.ui.EntityParentSelectBox;
import de.justsoftware.onx.container.presentation.client.ui.EntityParentSelectWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntitySelectWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntitySelectedParentsWidget;
import de.justsoftware.onx.container.presentation.client.ui.ParentEntityListSuggestionView;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityParentSelectWidget
extends Composite
implements Validatable {
    private static final EntityParentSelectWidgetUIBinder UI_BINDER = (EntityParentSelectWidgetUIBinder)GWT.create(EntityParentSelectWidgetUIBinder.class);
    private static final String MANDATORY = "mandatory";
    @UiField
    EntityParentSelectBox _parentSelectBox;
    @UiField
    EntitySelectedParentsWidget _selectedParentsWidget;
    @UiField
    DivElement _parentSelectionPanel;
    @UiField
    DivElement _selectedParentsPanel;
    @UiField
    LabelElement _addParentLabel;
    @UiField
    InlineFeedbackWidget _inlineFeedbackWidget;
    @UiField(provided=true)
    final EntityConstants _entityConstants;
    @Nonnull
    private final Map<EntityId, EntityParent> _selectedParents = Maps.newHashMap();
    private boolean _required = false;
    private EntityType _childType = null;
    private ImmutableSet<Action> _allowedActions = ImmutableSet.of();
    private final ClientFactory _clientFactory;
    private EntityParentChangeCallback _entityParentChangeCallback = null;

    public EntityParentSelectWidget(ClientFactory clientFactory, @Nonnull EntityConstants entityConstants) {
        this._entityConstants = entityConstants;
        this._clientFactory = clientFactory;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
    }

    public void setAdditionalSuggestionDisplayStyleName(@Nonnull String styleName) {
        this._parentSelectBox.setAdditionalSuggestionDisplayStyleName(styleName);
    }

    @Nonnull
    public ImmutableSet<EntityType> initAllowedEntityTypes(@Nullable EntityId entityId, @Nonnull EntityType childType, @Nonnull Predicate<EntityType> permissionProvider) {
        ClientEntityConfig entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)childType);
        this._required = entityConfig.isParentEntityRequired();
        if (this._required) {
            this._addParentLabel.addClassName("mandatory");
        } else {
            this._addParentLabel.removeClassName("mandatory");
        }
        this._childType = childType;
        ParentSelectedCallbackImpl parentSelectedCallback = new ParentSelectedCallbackImpl(this, entityId);
        EntityParentSelectPermissonValidator validator = new EntityParentSelectPermissonValidator(childType);
        ImmutableSet.Builder allowedParentTypesBuilder = ImmutableSet.builder();
        for (EntityType parentType : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
            ParentEntityConfig parentEntityConfig = entityConfig.getParentEntityConfig(parentType);
            if (parentEntityConfig == null || parentEntityConfig.getMaxCount() <= 0 || !permissionProvider.apply((Object)parentType)) continue;
            allowedParentTypesBuilder.add((Object)parentType);
        }
        ImmutableSet allowedParentTypes = allowedParentTypesBuilder.build();
        this._parentSelectBox.init(entityId, childType, (EntitySelectWidget.EntityTypeAheadSelectValidator)validator, (ParentEntityListSuggestionView.ParentSelectedCallback)parentSelectedCallback, this._clientFactory.entityFactory(), allowedParentTypes);
        EntityParentSelectWidget.setVisible((Element)this._parentSelectionPanel, (boolean)this._parentSelectBox.contentVisible());
        return allowedParentTypes;
    }

    @CheckForNull
    public EntityType getChildType() {
        return this._childType;
    }

    public void validate() throws ValidationException {
        this.clearErrors();
        EntityConstants entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)this._childType);
        EntityMessages entityMessages = I18nMediator.getEntityMessagesByEntityType((EntityType)this._childType);
        StringBuilder errors = new StringBuilder();
        boolean hasErrors = false;
        if (this._required && this._selectedParents.isEmpty()) {
            hasErrors = true;
            errors.append(entityConstants.parentEntityRequiredError()).append("\n");
        }
        if (this._childType != null) {
            ClientEntityConfig entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)this._childType);
            ImmutableListMultimap selectedParents = this.getSelectedParentsByType();
            for (EntityType parentType : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
                ParentEntityConfig parentEntityConfig = entityConfig.getParentEntityConfig(parentType);
                int minNumberOfParents = parentEntityConfig.getMinCount();
                int maxNumberOfParents = parentEntityConfig.getMaxCount();
                int numberOfSelectedParents = selectedParents.get((Object)parentType).size();
                EntityConstants parentConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)parentType);
                if (numberOfSelectedParents < minNumberOfParents) {
                    hasErrors = true;
                    errors.append(entityMessages.needToDefineMinEntity(minNumberOfParents, parentConstants.entity(parentType))).append("\n");
                }
                if (numberOfSelectedParents <= maxNumberOfParents) continue;
                hasErrors = true;
                errors.append(entityMessages.defineNotMoreThanEntity(maxNumberOfParents, parentConstants.entity(parentType))).append("\n");
            }
        }
        if (hasErrors) {
            String errorMessage = errors.toString();
            this.displayErrorMessage(errorMessage);
            throw new ValidationException(errorMessage);
        }
    }

    private void displayErrorMessage(@Nonnull String errorMessage) {
        this._inlineFeedbackWidget.setMessage(errorMessage);
        this._inlineFeedbackWidget.show(InlineFeedbackWidget.InlineType.ERROR);
    }

    public void clearErrors() {
        this._selectedParentsWidget.clearErrors();
        this._parentSelectBox.clearError();
        this._inlineFeedbackWidget.hide();
    }

    public void initView(@Nonnull List<EntityParent> selectedParentEntities, @Nonnull ImmutableSet<Action> allowedActions) {
        this._allowedActions = allowedActions;
        this._selectedParents.clear();
        for (EntityParent parent : selectedParentEntities) {
            this._selectedParents.put((EntityId)parent.getParentEntity().getId(), parent);
        }
        this.reloadView(true);
    }

    public boolean isShowWidget() {
        return UIObject.isVisible((Element)this._parentSelectionPanel) || UIObject.isVisible((Element)this._selectedParentsPanel);
    }

    @Nonnull
    private ImmutableListMultimap<EntityType, EntityParent> getSelectedParentsByType() {
        return Multimaps.index(this._selectedParents.values(), (Function)EntityParent.TO_ENTITY_TYPE);
    }

    public void displayErrorOnSelectedEntityTeasers(@Nonnull Set<EntityId> ids, @Nonnull String errorMessage) {
        this._selectedParentsWidget.showErrorMessageForEntities(ids, errorMessage);
    }

    @Nonnull
    public DeleteSelectedParentClickHandler createDeleteSelectedParentClickHandler(@Nonnull EntityInfo entity) {
        return new DeleteSelectedParentClickHandler(this, entity);
    }

    @Nonnull
    public ImmutableList<DBEntityLink> getSelectedParentsAsLinks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityParent parent : this._selectedParents.values()) {
            builder.add((Object)new DBEntityLink((EntityId)parent.getParentEntity().getId(), parent.isInheritAdmins(), parent.isInheritMembers()));
        }
        return builder.build();
    }

    @UiFactory
    @Nonnull
    public EntitySelectedParentsWidget createSelectedParentsWidget() {
        return new EntitySelectedParentsWidget(this);
    }

    public void setParentChangeCallback(@Nonnull EntityParentChangeCallback entityParentChangeCallback) {
        this._entityParentChangeCallback = entityParentChangeCallback;
    }

    private void reloadView(boolean set) {
        ImmutableList selectedParents = Ordering.from((Comparator)this._clientFactory.localizedMessages().localizedComparator()).nullsFirst().onResultOf(EntityParent.TO_ENTITY_NAME).immutableSortedCopy(this._selectedParents.values());
        this._selectedParentsWidget.reloadView((Iterable)selectedParents, this._allowedActions);
        EntityParentSelectWidget.setVisible((Element)this._selectedParentsPanel, (boolean)this._selectedParentsWidget.isVisible());
        if (this._entityParentChangeCallback != null) {
            this._entityParentChangeCallback.reloadView(this._childType, (Collection)selectedParents, set);
        }
        this._parentSelectBox.updateSelectedParents(ImmutableSet.copyOf(this._selectedParents.keySet()));
    }
}

