/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntityInheritMemberTeaserWidget;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.ParentEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberInheritSelectWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntityParentSelectWidget;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Collection;

public class EntityMemberInheritSelectWidget
extends Composite
implements EntityParentSelectWidget.EntityParentChangeCallback {
    private static final EntityMemberInheritSelectWidgetUIBinder UI_BINDER = (EntityMemberInheritSelectWidgetUIBinder)GWT.create(EntityMemberInheritSelectWidgetUIBinder.class);
    @UiField
    FlowPanel _entityRows;
    @UiField(provided=true)
    final EntityConstants _entityConstants;
    private ImmutableMap<EntityId, EntityInheritMemberTeaserWidget> _widgets = ImmutableMap.of();

    public EntityMemberInheritSelectWidget(EntityConstants entityConstants) {
        this._entityConstants = entityConstants;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
    }

    public void reloadView(EntityType childType, Collection<EntityParent> selectedParents, boolean reloadState) {
        this._entityRows.clear();
        boolean inheritAdminsActivated = false;
        boolean inheritMembersActivated = false;
        ImmutableMap.Builder widgets = ImmutableMap.builder();
        for (EntityParent entityParent : selectedParents) {
            ParentEntityConfig config;
            EntityInfo parentEntity = entityParent.getParentEntity();
            EntityId entityId = (EntityId)parentEntity.getId();
            EntityInheritMemberTeaserWidget existing = (EntityInheritMemberTeaserWidget)this._widgets.get((Object)entityId);
            EntityInheritMemberTeaserWidget widget = existing != null ? existing : new EntityInheritMemberTeaserWidget(entityParent.getParentEntity());
            widgets.put((Object)entityId, (Object)widget);
            this._entityRows.add((Widget)widget);
            if (childType != null) {
                ClientEntityConfig entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)childType);
                config = entityConfig.getParentEntityConfig((EntityType)parentEntity.getType());
                inheritAdminsActivated = inheritAdminsActivated || config != null && config.isInheritsAdminEnabled();
                inheritMembersActivated = inheritMembersActivated || config != null && config.isInheritsMemberEnabled();
            } else {
                config = null;
            }
            widget.setEntityParent(entityParent, childType, reloadState, config);
        }
        this.setStyleName("inheritAdminVisible", inheritAdminsActivated);
        this.setStyleName("inheritMemberVisible", inheritMembersActivated);
        this._widgets = widgets.build();
    }
}

