/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.ValidatableTextBox;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasVisibility;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoTooltip;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.IntegerTextBox;
import de.justsoftware.onx.common.presentation.client.ui.JCRadioButton;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.TimePeriodBox;
import de.justsoftware.onx.common.presentation.client.ui.TimeZoneListBox;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.Section;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.TimePeriod;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateBaseDataViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopupHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberInheritSelectWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntityParentSelectWidget;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import de.justsoftware.onx.util.presentation.client.ClientDOMUtil;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class EntityCreateBaseDataViewImpl
extends Composite
implements EntityCreateBaseDataView {
    protected static final int MAX_NAME_LENGTH = 255;
    private static final EntityCreateBaseDataViewUIBinder UI_BINDER = (EntityCreateBaseDataViewUIBinder)GWT.create(EntityCreateBaseDataViewUIBinder.class);
    @UiField
    ValidatableTextBox _name;
    @UiField
    JucoTooltip _baseDataTooltip;
    @UiField
    FlowPanel _modifyTitleRulePanel;
    @UiField
    DivElement _durationRow;
    @UiField
    TimePeriodBox _duration;
    @UiField
    DivElement _timeZoneRow;
    @UiField
    TimeZoneListBox _timeZone;
    @UiField
    DivElement _closingDateRow;
    @UiField
    TimestampBox _closingDate;
    @UiField
    DivElement _locationRow;
    @UiField
    ValidatableTextBox _location;
    @UiField
    ValidatableTextBox _tags;
    @UiField
    DivElement _tagsRow;
    @UiField
    EntityParentSelectWidget _entityParents;
    @UiField(provided=true)
    final EntityMemberInheritSelectWidget _inheritMember;
    @UiField
    Section _parentSelectionPanel;
    @UiField
    Section _inheritSelectionPanel;
    @UiField
    InlineFeedbackWidget _feedbackWidget;
    @UiField
    Section _visibilityRuleSection;
    @UiField
    FlowPanel _visibilityRulePanel;
    @UiField
    Section _entityEditRuleSection;
    @UiField
    FlowPanel _entityEditRulePanel;
    @UiField
    Section _joiningRuleSection;
    @UiField
    FlowPanel _joiningRulePanel;
    @UiField
    Section _sendJoinRequestRuleSection;
    @UiField
    FlowPanel _sendJoinRequestRulePanel;
    @UiField
    PlaceHolder _dynamicAttributesPlaceholder;
    @UiField
    IntegerTextBox _participantCount;
    @UiField
    DivElement _participantLimitRow;
    @UiField
    JCRadioButton _unlimitedParticipants;
    @UiField
    JCRadioButton _manualWaitlistParticipants;
    @UiField
    JCRadioButton _limitedParticipants;
    @UiField
    Section _appointmentSection;
    @UiField
    Section _additionalAppointmentSection;
    @UiField
    Section _tabSettingsSection;
    @UiField
    ListBox _defaultTabListBox;
    @UiField
    FocusPanel _showAdditionalOptionsPanel;
    @UiField
    FocusPanel _hideAdditionalOptionsPanel;
    @UiField
    FlowPanel _additionalOptionsPanel;
    private final ImmutableSet<Element> _appointmentRows;
    private final ImmutableSet<Element> _additionalAppointmentRows;
    private final ValidatorPanel.ValidatorPanelUtils _validatorPanelUtils = new ValidatorPanel.ValidatorPanelUtils();
    private final EntityMessages _entityMessages;
    private final EntityConstants _entityConstants;
    private ValidatorPanel _nameFieldValidatorPanel;
    private ValidatorPanel _participantCountFieldValidatorPanel;
    private final EntityType _type;
    private final ChangeHandlerImplementation _antiSuggestHandler;
    private final ClientFactory _clientFactory;
    private final EntityCreatePopupHandler _entityCreatePopupHandler;
    private boolean _focusNameInputElementOnAttach = false;
    private final List<Element> _additionalOptionsElements;
    private final List<HasVisibility> _additionalOptionsHasVisibilities;

    public EntityCreateBaseDataViewImpl(@Nonnull EntityType type, @Nonnull ClientFactory clientFactory, @Nonnull EntityCreatePopupHandler entityCreatePopupHandler) {
        this._type = type;
        this._clientFactory = clientFactory;
        this._entityCreatePopupHandler = entityCreatePopupHandler;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)this._type);
        this._entityMessages = I18nMediator.getEntityMessagesByEntityType((EntityType)this._type);
        this._inheritMember = new EntityMemberInheritSelectWidget(this._entityConstants);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        String baseDataTooltipText = this._entityConstants.basedataTooltip();
        if (ClientStringUtil.hasText((String)baseDataTooltipText)) {
            this._baseDataTooltip.setTooltipText(baseDataTooltipText);
        } else {
            this._baseDataTooltip.asWidget().setVisible(false);
        }
        this._entityParents.setParentChangeCallback((EntityParentSelectWidget.EntityParentChangeCallback)new /* Unavailable Anonymous Inner Class!! */);
        this._closingDate.getDateBox().addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.initValidator();
        this._antiSuggestHandler = new ChangeHandlerImplementation(this._type, this._name, this._nameFieldValidatorPanel);
        this._antiSuggestHandler.register();
        3 disableParticipantCountHandler = new /* Unavailable Anonymous Inner Class!! */;
        this._unlimitedParticipants.addValueChangeHandler((ValueChangeHandler)disableParticipantCountHandler);
        this._manualWaitlistParticipants.addValueChangeHandler((ValueChangeHandler)disableParticipantCountHandler);
        this._limitedParticipants.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._appointmentRows = ImmutableSet.of((Object)this._durationRow, (Object)this._timeZoneRow, (Object)this._locationRow);
        this._additionalAppointmentRows = ImmutableSet.of((Object)this._closingDateRow, (Object)this._participantLimitRow);
        this._showAdditionalOptionsPanel.addClickHandler(e -> this.setAdditionalOptionsVisible(true));
        this._hideAdditionalOptionsPanel.addClickHandler(e -> this.setAdditionalOptionsVisible(false));
        this._additionalOptionsElements = ImmutableList.of((Object)this._tagsRow);
        this._additionalOptionsHasVisibilities = ImmutableList.of((Object)this._additionalAppointmentSection, (Object)this._parentSelectionPanel, (Object)this._inheritSelectionPanel, (Object)this._tabSettingsSection, (Object)this._modifyTitleRulePanel, (Object)this._visibilityRuleSection, (Object)this._joiningRuleSection, (Object)this._sendJoinRequestRuleSection);
        this.setAdditionalOptionsVisible(false);
    }

    private void setAdditionalOptionsVisible(boolean visible) {
        this._additionalOptionsPanel.setVisible(visible);
        this._showAdditionalOptionsPanel.setVisible(!visible);
        if (!visible) {
            this._entityCreatePopupHandler.reCenter();
        }
    }

    public void clearValidationErrors() {
        this._validatorPanelUtils.clearError();
        this._entityParents.clearErrors();
    }

    public ImmutableSet<EntityType> initEntityParentAllowedTypes(EntityId entityId, EntityType childType, Predicate<EntityType> permissionProvider) {
        ImmutableSet allowedParentTypes = this._entityParents.initAllowedEntityTypes(entityId, childType, permissionProvider);
        this.setParentSelectionVisibility(this._entityParents.isShowWidget());
        return allowedParentTypes;
    }

    public void setEntityParents(List<EntityParent> parents, ImmutableSet<Action> allowedActions) {
        this._entityParents.initView(parents, allowedActions);
        this.setParentSelectionVisibility(this._entityParents.isShowWidget());
    }

    public void setDurationVisibility(boolean visible) {
        UIObject.setVisible((Element)this._durationRow, (boolean)visible);
        this.handleAppointmentSectionVisibility();
    }

    public void setTimeZoneVisibility(boolean visible) {
        UIObject.setVisible((Element)this._timeZoneRow, (boolean)visible);
        this.handleAppointmentSectionVisibility();
    }

    public void setClosingDateVisibility(boolean visible) {
        UIObject.setVisible((Element)this._closingDateRow, (boolean)visible);
        this.handleAppointmentSectionVisibility();
    }

    public void setParentSelectionVisibility(boolean visible) {
        this._parentSelectionPanel.setVisible(visible);
        this.updateAdditionalOptionsPanelVisibility();
    }

    public void setLocationVisibility(boolean visible) {
        UIObject.setVisible((Element)this._locationRow, (boolean)visible);
        this.handleAppointmentSectionVisibility();
    }

    @UiFactory
    EntityConstants getEntityConstants() {
        return this._entityConstants;
    }

    @UiFactory
    EntityMessages getEntityMessages() {
        return this._entityMessages;
    }

    @UiFactory
    EntityParentSelectWidget getEntityParentSelectWidget() {
        return new EntityParentSelectWidget(this._clientFactory, this._entityConstants);
    }

    public void setNameEnabled(boolean enabled) {
        this._name.setEnabled(enabled);
    }

    public void setName(String name) {
        this._name.setText(name);
        this._antiSuggestHandler.addToWhiteList(name);
    }

    public void setDuration(TimePeriod duration) {
        this._duration.setValue((Object)duration);
    }

    public void setTags(String tags) {
        this._tags.setText(tags);
    }

    public void setClosingDate(Date closingDate) {
        this._closingDate.setValue((Object)closingDate);
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone.setValue((Object)timeZone);
    }

    public void setLocation(String location) {
        this._location.setText(location);
    }

    private void initValidator() {
        ClientEntityConfig entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)this._type);
        this._name.setMandatory(true);
        this._name.setMaxLength(255);
        this._nameFieldValidatorPanel = this._validatorPanelUtils.addWrappedValidatable((Widget)this._name);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._duration);
        this._duration.setMandatory(entityConfig.getDurationTimeOption() != EntityDurationTimeOption.OFF);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._timeZone);
        this._timeZone.setMandatory(entityConfig.getDurationTimeOption() == EntityDurationTimeOption.WITH_TIME_ZONE);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._closingDate);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._location);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._tags);
    }

    public void validate(AsyncCallback<Boolean> callback) {
        this.clearValidationErrors();
        boolean hasError = false;
        this.prepareParticipantCountValidation();
        try {
            this._validatorPanelUtils.validate();
        }
        catch (ValidationException e) {
            hasError = true;
        }
        try {
            this._entityParents.validate();
        }
        catch (ValidationException e) {
            hasError = true;
        }
        if (hasError) {
            callback.onSuccess((Object)Boolean.TRUE);
            return;
        }
        String name = this._name.getText();
        this._antiSuggestHandler.check(name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void prepareParticipantCountValidation() {
        if (Boolean.TRUE.equals(this._limitedParticipants.getValue())) {
            if (this._participantCountFieldValidatorPanel == null) {
                this._participantCountFieldValidatorPanel = this._validatorPanelUtils.addWrappedValidatable((Widget)this._participantCount);
            }
        } else {
            this._validatorPanelUtils.removeWrappedValidatableById(this._participantCountFieldValidatorPanel);
            this._participantCountFieldValidatorPanel = null;
        }
    }

    public void displayErrorOnSelectedParentEntityIds(Set<EntityId> ids, String errorMessage) {
        this._entityParents.displayErrorOnSelectedEntityTeasers(ids, errorMessage);
    }

    public String getName() {
        return this._name.getValue();
    }

    public String getTags() {
        return this._tags.getValue();
    }

    public TimePeriod getDuration() {
        return this._duration.getValue();
    }

    public Date getClosingDate() {
        return this._closingDate.getValue();
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this._timeZone.getValue();
    }

    public String getLocation() {
        return this._location.getValue();
    }

    public List<DBEntityLink> getSelectedParentsAsLinks() {
        return this._entityParents.getSelectedParentsAsLinks();
    }

    public void showFeedbackMessageAndHideAfterDelay(InlineFeedbackWidget.InlineType type, String messages) {
        this._feedbackWidget.showAndHideAfterDelay(messages, type);
    }

    public void setTagsVisibility(boolean visible) {
        UIObject.setVisible((Element)this._tagsRow, (boolean)visible);
        this.updateAdditionalOptionsPanelVisibility();
    }

    public PlaceHolder getDynamicAttributesPlaceholder() {
        return this._dynamicAttributesPlaceholder;
    }

    public void setDynamicAttributesVisible(boolean visible) {
    }

    public void setCheckEntityDuplicateName(boolean checkEntityDuplicateName) {
        this._antiSuggestHandler.setActive(checkEntityDuplicateName);
    }

    public void setHasParticipantCapacity(boolean hasParticipantCapacity) {
        UIObject.setVisible((Element)this._participantLimitRow, (boolean)hasParticipantCapacity);
        this.handleAppointmentSectionVisibility();
    }

    public void setParticipantLimit(int participantCount) {
        if (participantCount < 0) {
            this._unlimitedParticipants.setValue(Boolean.TRUE);
            this._participantCount.setEnabled(false);
        } else if (participantCount == 0) {
            this._manualWaitlistParticipants.setValue(Boolean.TRUE);
            this._participantCount.setEnabled(false);
        } else {
            this._limitedParticipants.setValue(Boolean.TRUE);
            this._participantCount.setEnabled(true);
            this._participantCount.setIntValue(participantCount);
        }
    }

    public Integer getParticipantLimit() {
        return this._participantCount.getIntegerValue();
    }

    public boolean isHasParticipantLimit() {
        return this._limitedParticipants.getValue();
    }

    public boolean isHasManualWaitinglist() {
        return this._manualWaitlistParticipants.getValue();
    }

    public void setParticipantCountRange(int min, int max) {
        this._participantCount.setMinValue(min);
        this._participantCount.setMaxValue(max);
    }

    private void handleAppointmentSectionVisibility() {
        this._appointmentSection.setVisible(Iterables.any((Iterable)this._appointmentRows, (Predicate)ClientDOMUtil.IS_VISIBLE));
        this._additionalAppointmentSection.setVisible(Iterables.any((Iterable)this._additionalAppointmentRows, (Predicate)ClientDOMUtil.IS_VISIBLE));
        this.updateAdditionalOptionsPanelVisibility();
    }

    public HasWidgets.ForIsWidget getJoiningRuleView() {
        return this._joiningRulePanel;
    }

    public HasWidgets.ForIsWidget getVisibilityRuleView() {
        return this._visibilityRulePanel;
    }

    public HasWidgets.ForIsWidget getEditEntityRuleView() {
        return this._entityEditRulePanel;
    }

    public HasVisibility getEditEntityRuleSection() {
        return this._entityEditRuleSection;
    }

    public HasWidgets.ForIsWidget getSendJoinRequestRuleView() {
        return this._sendJoinRequestRulePanel;
    }

    public HasVisibility getJoiningRuleSection() {
        return new HasVisibilityWrapper(this, (Widget)this._joiningRuleSection);
    }

    public HasVisibility getVisibilityRuleSection() {
        return new HasVisibilityWrapper(this, (Widget)this._visibilityRuleSection);
    }

    public HasVisibility getSendJoinRequestRuleSection() {
        return new HasVisibilityWrapper(this, (Widget)this._sendJoinRequestRuleSection);
    }

    public void setAvailableEntityTabs(ImmutableList<EntityTab> tabs, Function<EntityTab, String> toTranslatedNameFunction) {
        this._defaultTabListBox.clear();
        for (EntityTab tab : tabs) {
            this._defaultTabListBox.addItem((String)toTranslatedNameFunction.apply((Object)tab), tab.getName());
        }
    }

    public void setSelectedEntityTab(EntityTab selectedTab) {
        this._defaultTabListBox.setSelectedValue(selectedTab.getName());
    }

    public EntityTab getSelectedEntityTab() {
        String selectedValue = this._defaultTabListBox.getSelectedValue();
        return selectedValue == null ? null : EntityTabUtils.fromName((String)selectedValue);
    }

    public void showTabSettingsSection() {
        this._tabSettingsSection.setVisible(true);
        this.updateAdditionalOptionsPanelVisibility();
    }

    public HasWidgets.ForIsWidget getModifyTitleRuleView() {
        return this._modifyTitleRulePanel;
    }

    public HasVisibility getModifyTitleRuleSection() {
        return new HasVisibilityWrapper(this, (Widget)this._modifyTitleRulePanel);
    }

    protected void onAttach() {
        super.onAttach();
        this._name.setFocus(this._focusNameInputElementOnAttach);
    }

    public void focusName() {
        this._focusNameInputElementOnAttach = true;
    }

    private void updateAdditionalOptionsPanelVisibility() {
        boolean addtionalOptionsVisible = this._additionalOptionsElements.stream().anyMatch(e -> UIObject.isVisible((Element)e)) || this._additionalOptionsHasVisibilities.stream().anyMatch(e -> e.isVisible());
        this._showAdditionalOptionsPanel.setVisible(addtionalOptionsVisible);
    }
}

