/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableList;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.presentation.client.ui.SelectableEntityTeaserCell;
import de.justsoftware.onx.container.presentation.client.ui.ShowMorePopupView;
import de.justsoftware.onx.container.presentation.client.ui.ShowMorePopupViewImpl;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class InheritsParentListOverlayPresenter
implements ShowMorePopupView.Presenter {
    private static final int ITEMS_PER_PAGE = 15;
    private final ShowMorePopupView<EntityInfo> _view;
    private EntityId _entityId;
    private ImmutableList<EntityInfo> _entityInfosCache = null;

    protected InheritsParentListOverlayPresenter() {
        SelectableEntityTeaserCell cell = new SelectableEntityTeaserCell();
        this._view = new ShowMorePopupViewImpl((Cell)cell, 15);
        this._view.setPresenter((ShowMorePopupView.Presenter)this);
        this._view.setNoDataText(I18nMediator.BASIC_CONSTANTS.noEntries());
    }

    public void togglePopup(@Nonnull EntityId entityId, @Nonnull EntityType childType, @Nonnull Widget bindingWidget) {
        this._view.setCaption(this.getCaption(I18nMediator.getEntityConstantsByEntityType((EntityType)childType)));
        if (!entityId.equals((Object)this._entityId)) {
            this._entityId = entityId;
            this._entityInfosCache = null;
            this._view.hide();
        }
        if (this._view.isShowing()) {
            this._view.hide();
        } else {
            this._view.show(bindingWidget);
        }
    }

    public void onRangeChange(int offset, int limit) {
        if (this._entityId == null) {
            return;
        }
        if (this._entityInfosCache != null) {
            this.updateView((List)this._entityInfosCache, offset, limit);
        } else {
            this.getInheritsParentList(this._entityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateView(@Nonnull List<EntityInfo> list, int offset, int limit) {
        this._view.getList().setRowCount(list.size(), true);
        this._view.getList().setRowData(offset, CollectionUtil.subList(list, (int)offset, (int)(offset + limit)));
    }

    protected abstract void getInheritsParentList(@Nonnull EntityId var1, @Nonnull AsyncCallback<ImmutableList<EntityInfo>> var2);

    protected abstract String getCaption(@Nonnull EntityConstants var1);
}

