/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.TimePeriod;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreateOrEditBaseDataPresenter;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreatedCallback;
import de.justsoftware.onx.container.presentation.client.presenter.EntityEditBaseDataPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditSubmitButtonsHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditDynamicAttributesForm;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.BaseEntityEditModel;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class EntityEditBaseDataPresenter
extends EntityCreateOrEditBaseDataPresenter {
    private final BaseEntityEditModel _entityEditModel;
    private final EntityId _entityId;
    private final Callback<String> _cancelCallback;
    private EntityEditBaseDataView _baseDataView;
    private String _oldLocations;
    private TimePeriod _oldTimePeriod;
    private TimeZone _oldTimeZone;

    public EntityEditBaseDataPresenter(EntityId entityId, BaseEntityEditModel entityEditModel, ClientFactory cf, EntityCreatedCallback submitCallback, Callback<String> cancelCallback) {
        super(entityEditModel.getEntityType(), cf, submitCallback);
        this._entityId = entityId;
        this._entityEditModel = entityEditModel;
        this._cancelCallback = cancelCallback;
    }

    public void start(AcceptsOneWidget widget) {
        this._baseDataView = this._clientFactory.entityFactory().getEntityEditBaseDataView(this._entityType);
        this._baseDataView.addCancelClickHandler(event -> this._cancelCallback.call(null));
        this.configureView((EntityCreateOrEditBaseDataView)this._baseDataView);
        this.initView();
        this._dynamicAttributesForm = new EntityEditDynamicAttributesForm(this._entityEditModel.getEntityType(), this._entityEditModel.getDBEntity().getDynamicAttributes(), this._clientFactory, false);
        this._baseDataView.getDynamicAttributesPlaceholder().replace((IsWidget)this._dynamicAttributesForm.asWidget());
        String tenantName = this._entityEditModel.getTenantName();
        this.fillViewFields((EntityCreateOrEditBaseDataView)this._baseDataView, this._entityEditModel.getDBEntity(), this._entityEditModel.getPrivacySelections(), tenantName);
        this.configureContinueButton();
        this._baseDataView.focusName();
        widget.setWidget((IsWidget)this._baseDataView.asWidget());
    }

    private void configureContinueButton() {
        ImmutableMap visibleTabs = FluentIterable.from((Iterable)this._entityEditModel.getVisibleTabs()).filter(tab -> EditEntityHistoryTokenTabName.BASE != tab).toMap(tab -> e -> this.submit((EntityCreateOrEditBaseDataView)this._baseDataView, tab));
        if (!visibleTabs.isEmpty()) {
            this._baseDataView.addSaveAndContinueButton(visibleTabs);
        }
    }

    EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    private static ImmutableList<EntityParent> getEntityParentFromEntityDetails(BaseEntityEditModel entityEditModel) {
        ImmutableList linkedEntities = entityEditModel.getLinkedEntities();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableMap infoMap = Maps.uniqueIndex((Iterable)linkedEntities, (Function)Identifiables.toId());
        for (DBEntityLink link : entityEditModel.getDBEntity().getLinkedEntities()) {
            EntityInfo entityInfo = (EntityInfo)infoMap.get((Object)link.getLinkedEntityId());
            if (entityInfo == null) continue;
            builder.add((Object)new EntityParent(entityInfo, link.isInheritsAdmins(), link.isInheritsMembers()));
        }
        return builder.build();
    }

    private void initView() {
        this._baseDataView.setNameEnabled(this._entityEditModel.getPermissions().contains((Object)StaticEntityAction.ENTITY_MODIFY_TITLE));
        this._baseDataView.setFinishButtonText(this._entityConstants.finish());
        this._baseDataView.initEntityParentAllowedTypes(this._entityId, this._entityType, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        this._baseDataView.setEntityParents((List)EntityEditBaseDataPresenter.getEntityParentFromEntityDetails((BaseEntityEditModel)this._entityEditModel), this._entityEditModel.getPermissions());
        DBEntity entity = this._entityEditModel.getDBEntity();
        this._oldLocations = this._entityConfig.isFreetextLocationActivated() ? entity.getLocation() : null;
        if (this._entityConfig.getDurationTimeOption() != EntityDurationTimeOption.OFF) {
            this._oldTimePeriod = new TimePeriod((Date)entity.getStartAt(), (Date)entity.getEndAt());
            this._oldTimeZone = this._entityConfig.getDurationTimeOption() == EntityDurationTimeOption.WITH_TIME_ZONE ? entity.getTimeZone() : null;
        } else {
            this._oldTimePeriod = null;
            this._oldTimeZone = null;
        }
        this._baseDataView.addFinishButtonClickHandler(event -> this.submit((EntityCreateOrEditBaseDataView)this._baseDataView, null));
        if (!this._entityConfig.getEntityTabOrder().isEmpty() && this._entityEditModel.getPermissions().contains((Object)StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS)) {
            this._baseDataView.showTabSettingsSection();
        }
    }

    protected EntityCreateOrEditSubmitButtonsHandler getSubmitButtonsHandler() {
        return this._baseDataView;
    }

    private void submit(EntityCreateOrEditBaseDataView view, @Nullable EditEntityHistoryTokenTabName nextTab) {
        this.setSubmitPossible(false);
        this.validate(view, (EntityCreateOrEditBaseDataPresenter.ValidationCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateEntityBaseData(EntityCreateOrEditBaseDataView view, EntityBaseData entityBaseData, @Nullable EditEntityHistoryTokenTabName nextTab) {
        ClientEntityConfig clientEntityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)this._entityType);
        DBEntity entity = entityBaseData.getEntity();
        boolean locationChanged = clientEntityConfig.isFreetextLocationActivated() && !Objects.equal((Object)entity.getLocation(), (Object)this._oldLocations);
        boolean durationChanged = clientEntityConfig.getDurationTimeOption() != EntityDurationTimeOption.OFF && (!Objects.equal((Object)this._oldTimePeriod.getStartTimestamp(), (Object)entity.getStartAt()) || !Objects.equal((Object)this._oldTimePeriod.getEndTimestamp(), (Object)entity.getEndAt()) || !Objects.equal((Object)this._oldTimeZone, (Object)entity.getTimeZone()));
        3 saveCallback = new /* Unavailable Anonymous Inner Class!! */;
        if (locationChanged && clientEntityConfig.isNotifyMemberOnLocationChangeActivated() || durationChanged && clientEntityConfig.isNotifyMemberOnDurationTimeChangeActivated()) {
            ConfirmPopup.makeConfirmPopup((String)this._entityConstants.notifyEntityAboutDataChange(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ConfirmPopup.ButtonType)ConfirmPopup.ButtonType.YES_NO).center();
        } else {
            EntityMediator.getInstance().updateEntityBaseData(entityBaseData, false, (AsyncCallback)saveCallback);
        }
    }
}

