/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasVisibility;
import com.google.gwt.user.client.ui.HasWidgets;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.PersonRoleListItem;
import de.justsoftware.onx.common.presentation.client.ui.components.AuthorityListPresenter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.TimePeriod;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreateOrEditBaseDataPresenter;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreatedCallback;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditSubmitButtonsHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditDynamicAttributesForm;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import java.util.Collection;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class EntityCreateOrEditBaseDataPresenter {
    protected final EntityType _entityType;
    protected final EntityConstants _entityConstants;
    protected final EntityMessages _entityMessages;
    protected final ClientEntityConfig _entityConfig;
    protected final LoadingDialog _loadingDialog;
    protected final ClientFactory _clientFactory;
    protected final EntityCreatedCallback _submitCallback;
    protected EntityEditDynamicAttributesForm _dynamicAttributesForm;
    private final ImmutableList<EntityTab> _availableTabs;
    private AuthorityListPresenter _visibilityRolesPresenter;
    private AuthorityListPresenter _joiningRolesPresenter;
    private AuthorityListPresenter _joinRequestRolesPresenter;
    private AuthorityListPresenter _modifyTitleRolesPresenter;
    private AuthorityListPresenter _entityEditRolesPresenter;

    protected EntityCreateOrEditBaseDataPresenter(@Nonnull EntityType entityType, @Nonnull ClientFactory cf, @Nonnull EntityCreatedCallback submitCallback) {
        this._clientFactory = cf;
        this._entityType = entityType;
        this._submitCallback = submitCallback;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)this._entityType);
        this._entityMessages = I18nMediator.getEntityMessagesByEntityType((EntityType)this._entityType);
        this._entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)this._entityType);
        this._loadingDialog = new LoadingDialog();
        this._availableTabs = this._entityConfig.getEntityTabOrder();
    }

    protected void configureView(@Nonnull EntityCreateOrEditBaseDataView view) {
        view.setDurationVisibility(this._entityConfig.getDurationTimeOption() != EntityDurationTimeOption.OFF);
        view.setTimeZoneVisibility(this._entityConfig.getDurationTimeOption() == EntityDurationTimeOption.WITH_TIME_ZONE);
        view.setClosingDateVisibility(this._entityConfig.isClosingDateActivated());
        view.setLocationVisibility(this._entityConfig.isFreetextLocationActivated());
        view.setParentSelectionVisibility(this.isShowParentSelection());
        view.setTagsVisibility(this._entityConfig.isTagsEnabled());
        view.setCheckEntityDuplicateName(this._entityConfig.isCheckEntityDuplicateName());
        view.setParticipantCountRange(1, Integer.MAX_VALUE);
        EntityMemberWorkflow workflow = this._entityConfig.getEntityMemberWorkflow();
        view.setHasParticipantCapacity(workflow == EntityMemberWorkflow.EVENT);
    }

    protected final void fillViewFields(@Nonnull EntityCreateOrEditBaseDataView view, DBEntity entity, ImmutableSetMultimap<DBPrivacyType, String> selectedAuthorityNames, String tenantName) {
        view.setName(entity.getName());
        TimePeriod period = new TimePeriod((Date)entity.getStartAt(), (Date)entity.getEndAt());
        view.setDuration(period);
        view.setClosingDate((Date)entity.getClosingDate());
        view.setTimeZone(entity.getTimeZone());
        view.setLocation(entity.getLocation());
        view.setTags(entity.getTags());
        view.setParticipantLimit(entity.getParticipantLimit());
        this._loadingDialog.center();
        this._visibilityRolesPresenter = this.createRolePresenter(selectedAuthorityNames, DBPrivacyType.VISIBILITY, view.getVisibilityRuleView(), view.getVisibilityRuleSection());
        this._joiningRolesPresenter = this.createRolePresenter(selectedAuthorityNames, DBPrivacyType.JOINING, view.getJoiningRuleView(), view.getJoiningRuleSection());
        this._joinRequestRolesPresenter = this.createRolePresenter(selectedAuthorityNames, DBPrivacyType.JOIN_REQUEST, view.getSendJoinRequestRuleView(), view.getSendJoinRequestRuleSection());
        this._modifyTitleRolesPresenter = this.createRolePresenter(selectedAuthorityNames, DBPrivacyType.MODIFY_TITLE, view.getModifyTitleRuleView(), view.getModifyTitleRuleSection());
        this._entityEditRolesPresenter = this.createRolePresenter(selectedAuthorityNames, DBPrivacyType.ENTITY_EDIT, view.getEditEntityRuleView(), view.getEditEntityRuleSection());
        this._loadingDialog.hide();
        if (!this._availableTabs.isEmpty()) {
            this.fillTabSettingsSection(view, entity.getDefaultTab());
        }
    }

    @Nonnull
    private AuthorityListPresenter createRolePresenter(@Nonnull ImmutableSetMultimap<DBPrivacyType, String> selectedAuthorityNames, @Nonnull DBPrivacyType privacy, @Nonnull HasWidgets.ForIsWidget view, @Nullable HasVisibility section) {
        return new AuthorityListPresenter(this._clientFactory.administrationClientFactory(), PersonRoleListItem.fromAuthorityModelList((Collection)this._entityConfig.getAvailableRuleAuthNames().get((Object)privacy)), selectedAuthorityNames.get((Object)privacy)).show(view, section);
    }

    private void fillTabSettingsSection(@Nonnull EntityCreateOrEditBaseDataView view, @Nullable EntityTab entityDefaultTab) {
        EntityTabUtils.DefaultEntityTab configDefaultTab = EntityTabUtils.DefaultEntityTab.createFrom((EntityTab)EntityTabUtils.getDefaultTabFromAvailableTabs((ImmutableList)this._availableTabs));
        ImmutableList availableTabsWithDefault = configDefaultTab == null ? this._availableTabs : ImmutableList.builder().add((Object)configDefaultTab).addAll((Iterable)this._availableTabs).build();
        EntityTab selectedTab = EntityTabUtils.getSelectedDefaultTab((ImmutableList)availableTabsWithDefault, (EntityTab)entityDefaultTab);
        TabTitleVisitor tabTitleVisitor = new TabTitleVisitor(this);
        1 toTabTitle = new /* Unavailable Anonymous Inner Class!! */;
        view.setAvailableEntityTabs(availableTabsWithDefault, (Function)toTabTitle);
        if (selectedTab != null) {
            view.setSelectedEntityTab(selectedTab);
        }
    }

    private void setDurationsFromView(@Nonnull DBEntity entity, @Nonnull EntityCreateOrEditBaseDataView view) {
        EntityDurationTimeOption durationTimeOption = this._entityConfig.getDurationTimeOption();
        if (durationTimeOption != EntityDurationTimeOption.OFF) {
            TimePeriod duration;
            if (durationTimeOption == EntityDurationTimeOption.WITH_TIME_ZONE) {
                entity.setTimeZone(view.getTimeZone());
            }
            if ((duration = view.getDuration()) != null) {
                entity.setStartAt(DateWithoutTimezone.clone((Date)duration.getStartTimestamp()));
                entity.setEndAt(DateWithoutTimezone.clone((Date)duration.getEndTimestamp()));
            }
        } else {
            entity.setTimeZone(null);
            entity.setStartAt(null);
            entity.setEndAt(null);
        }
        Date closingDate = view.getClosingDate();
        entity.setClosingDate(this._entityConfig.isClosingDateActivated() && closingDate != null ? new DateWithoutTimezone(closingDate) : null);
    }

    @CheckForNull
    abstract EntityId getEntityId();

    @Nonnull
    protected DBEntity getEntityFromView(@Nonnull EntityCreateOrEditBaseDataView view) {
        DBEntity entity = new DBEntity();
        entity.setId(this.getEntityId());
        entity.setType(this._entityType);
        entity.setName(view.getName());
        entity.setTags(view.getTags());
        entity.setLinkedEntities(view.getSelectedParentsAsLinks());
        this.setDurationsFromView(entity, view);
        entity.setLocation(this._entityConfig.isFreetextLocationActivated() ? view.getLocation() : null);
        entity.setParticipantLimit(this.getParticipantLimit(view));
        EntityTab newDefaultTab = view.getSelectedEntityTab();
        EntityTabUtils.DefaultEntityTab configDefaultTab = EntityTabUtils.DefaultEntityTab.createFrom((EntityTab)EntityTabUtils.getDefaultTabFromAvailableTabs((ImmutableList)this._entityConfig.getEntityTabOrder()));
        if (newDefaultTab == null || newDefaultTab.equals(configDefaultTab)) {
            entity.setDefaultTab(null);
        } else {
            entity.setDefaultTab(newDefaultTab);
        }
        return entity;
    }

    private int getParticipantLimit(@Nonnull EntityCreateOrEditBaseDataView view) {
        if (view.isHasManualWaitinglist()) {
            return 0;
        }
        if (view.isHasParticipantLimit()) {
            Integer limit = view.getParticipantLimit();
            int invalidLimit = Integer.MIN_VALUE;
            if (limit == null) {
                return Integer.MIN_VALUE;
            }
            int intLimit = limit;
            return intLimit > 0 ? intLimit : Integer.MIN_VALUE;
        }
        return -1;
    }

    @Nonnull
    protected EntityBaseData getEntityBaseDataFromView(@Nonnull EntityCreateOrEditBaseDataView view) {
        return new EntityBaseData(this.getEntityFromView(view), this._visibilityRolesPresenter.getSelected(), this._joiningRolesPresenter.getSelected(), this._joinRequestRolesPresenter.getSelected(), this._modifyTitleRolesPresenter.getSelected(), this._entityEditRolesPresenter.getSelected(), this._dynamicAttributesForm.getValues(), null);
    }

    private boolean isShowParentSelection() {
        for (EntityType parentType : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
            if (this._entityConfig.getParentEntityConfig(parentType).getMaxCount() <= 0) continue;
            return true;
        }
        return false;
    }

    protected void validate(@Nonnull EntityCreateOrEditBaseDataView view, @Nonnull ValidationCallback validationCallback) {
        EntityBaseData baseData = this.getEntityBaseDataFromView(view);
        this._dynamicAttributesForm.clearErrorMessages();
        view.validate((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setSubmitPossible(boolean submitPossible) {
        EntityCreateOrEditSubmitButtonsHandler submitButtonsHandler = this.getSubmitButtonsHandler();
        submitButtonsHandler.setSubmitButtonsEnabled(submitPossible);
        submitButtonsHandler.setWaitIconVisibility(!submitPossible);
    }

    @Nonnull
    protected abstract EntityCreateOrEditSubmitButtonsHandler getSubmitButtonsHandler();
}

