/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.gwt.i18n.dynamic.client.AbstractDynamicI18n;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.presenter.EntityOptionsPresenter;
import de.justsoftware.onx.common.presentation.client.ui.EntityOptionsView;
import de.justsoftware.onx.common.presentation.client.ui.EntityOptionsViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidgetProvider;
import de.justsoftware.onx.common.presentation.client.ui.form.DynamicAttributeInputView;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntitySelectedParentTeaserWidget;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntitySlideshowTeaserView;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntitySlideshowTeaserViewImpl;
import de.justsoftware.onx.common.shared.i18n.EntityTranslationUtil;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.SelectOptionMessage;
import de.justsoftware.onx.container.presentation.client.EntityClientFactory;
import de.justsoftware.onx.container.presentation.client.EntityClientFactoryImpl;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.presenter.ParentEntityListSuggestionPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateBaseDataViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopupHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditBaseDataViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntitySearchTabWidget;
import de.justsoftware.onx.container.presentation.client.ui.JustEntityAppPage;
import de.justsoftware.onx.container.presentation.client.ui.ParentEntityListSuggestionView;
import de.justsoftware.onx.container.presentation.client.ui.ParentEntityListSuggestionViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.model.SelectedTab;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbView;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorSearchResultWidget;
import de.justsoftware.onx.container.presentation.shared.EntityConfigController;
import de.justsoftware.onx.container.presentation.shared.EntityConfigControllerAsync;
import de.justsoftware.onx.container.presentation.shared.EntityEditRemoteService;
import de.justsoftware.onx.container.presentation.shared.EntityEditRemoteServiceAsync;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterCallback;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityClientFactoryImpl
implements EntityClientFactory {
    private static final String VALUE_SEPERATOR = ", ";
    private static final Map<String, DynamicEntityAttributesMessages> ENTITY_ATTRIBUTES_MAP = Maps.newHashMap();
    private static final Map<String, Map<String, SelectOptionMessage>> ENTITY_ATTRIBUTE_VALUE_TRANSLATIONS = Maps.newHashMap();
    private final EntityConfigControllerAsync _entityConfigController = (EntityConfigControllerAsync)GWT.create(EntityConfigController.class);
    private final EntityEditRemoteServiceAsync _entityEditRemoteService = (EntityEditRemoteServiceAsync)GWT.create(EntityEditRemoteService.class);
    private final ClientFactory _clientFactory;
    private final LinkedHashMap<EntityTabWidgetCacheKey, SearchResultWidget> _entitySearchTabWidgets = new /* Unavailable Anonymous Inner Class!! */;
    private JustEntityAppPage _entityAppPage;

    public EntityClientFactoryImpl(ClientFactory clientFactory) {
        UrlUtil.setRemoteServiceUrl((Object)this._entityConfigController, (String)"/entityConfig");
        UrlUtil.setRemoteServiceUrl((Object)this._entityEditRemoteService, (String)"/entityEdit");
        this._clientFactory = clientFactory;
    }

    public EntityConfigControllerAsync entityConfigController() {
        return this._entityConfigController;
    }

    public void withDynamicAttributeMessages(EntityType entityType, DynamicAttributeId attributeId, AsyncCallback<DynamicEntityAttributesMessages> msgCallback) {
        msgCallback.onSuccess((Object)this.getDynamicAttributeMessages(entityType, attributeId));
    }

    public DynamicEntityAttributesMessages getDynamicAttributeMessages(EntityType entityType, DynamicAttributeId attributeId) {
        String translationKey = EntityTranslationUtil.getEntityTypeAttributesKeyPart((EntityType)entityType, (DynamicAttributeId)attributeId);
        if (ENTITY_ATTRIBUTES_MAP.containsKey(translationKey)) {
            return (DynamicEntityAttributesMessages)ENTITY_ATTRIBUTES_MAP.get(translationKey);
        }
        DynamicEntityAttributesMessages dynamicAttributesMessages = (DynamicEntityAttributesMessages)GWT.create(DynamicEntityAttributesMessages.class);
        ((AbstractDynamicI18n)dynamicAttributesMessages).setKeyPrefix(translationKey);
        ENTITY_ATTRIBUTES_MAP.put(translationKey, dynamicAttributesMessages);
        return dynamicAttributesMessages;
    }

    public DynamicAttributeInputView<String> getInputView(DynamicAttributeConfig config, DynamicAttributeInputView.Presenter<String> presenter, EntityType entityType, @Nullable String personSuggestPopupStyle) {
        return (DynamicAttributeInputView)config.getInput().accept((Input.InputVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public EntityConstants entityConstants(EntityType type) {
        return I18nMediator.getEntityConstantsByEntityType((EntityType)type);
    }

    public EntityMessages entityMessages(EntityType type) {
        return I18nMediator.getEntityMessagesByEntityType((EntityType)type);
    }

    public ClientEntityConfig entityConfig(EntityType type) {
        return HostPropertiesMediator.getClientEntityConfig((EntityType)type);
    }

    public Map<String, SelectOptionMessage> getSelectableValueTranslations(EntityType type, DynamicAttributeId attributeId, ImmutableList<String> values) {
        String attributePrefix = "Entity/Attributes/" + EntityTranslationUtil.getEntityTypeAttributesKeyPart((EntityType)type, (DynamicAttributeId)attributeId) + "/values/";
        Map cachedTranslations = (Map)ENTITY_ATTRIBUTE_VALUE_TRANSLATIONS.get(attributePrefix);
        if (cachedTranslations != null) {
            return cachedTranslations;
        }
        HashMap translations = Maps.newHashMap();
        for (String value : values) {
            String translationKey = attributePrefix + value;
            SelectOptionMessage message = (SelectOptionMessage)GWT.create(SelectOptionMessage.class);
            ((AbstractDynamicI18n)message).setKeyPrefix(translationKey);
            translations.put(value, message);
        }
        ENTITY_ATTRIBUTE_VALUE_TRANSLATIONS.put(attributePrefix, translations);
        return translations;
    }

    public String getDynamicAttributeTranslation(EntityType type, EntityDynamicAttributeClientModel dynamicAttribute) {
        Map translations = this.getSelectableValueTranslations(type, dynamicAttribute.getAttributeId(), dynamicAttribute.getValues());
        Iterable translatedValues = Iterables.transform((Iterable)dynamicAttribute.getValues(), (Function)new /* Unavailable Anonymous Inner Class!! */);
        return Joiner.on((String)VALUE_SEPERATOR).join(translatedValues);
    }

    public EntitySlideshowTeaserView getEntitySlideshowTeaserView(EntitySlideshowTeaserView.Presenter presenter) {
        return new EntitySlideshowTeaserViewImpl(presenter);
    }

    public EntityCreateBaseDataView getEntityCreateBaseDataView(EntityType type, EntityCreatePopupHandler entityCreatePopupHandler) {
        return new EntityCreateBaseDataViewImpl(type, this._clientFactory, entityCreatePopupHandler);
    }

    public EntityEditBaseDataView getEntityEditBaseDataView(EntityType type) {
        return new EntityEditBaseDataViewImpl(type, this._clientFactory);
    }

    public EntityMediator controller() {
        return EntityMediator.getInstance();
    }

    public ParentEntityListSuggestionView createParentEntityListSuggestionView(int itemsPerPage, ParentEntityListSuggestionPresenter presenter, PanelPagingWidgetProvider<EntityInfo> provider) {
        return new ParentEntityListSuggestionViewImpl(itemsPerPage, provider);
    }

    public IsWidget createEntitySelectedParentTeaserWidget(EntityInfo entityInfo, ParentEntityListSuggestionView.ParentSelectedCallback parentSelectedCallback) {
        return new EntitySelectedParentTeaserWidget(entityInfo, parentSelectedCallback, null);
    }

    public EntityEditRemoteServiceAsync entityEditRemoteService() {
        return this._entityEditRemoteService;
    }

    public EntityOptionsPresenter entityOptionsPresenter() {
        return new EntityOptionsPresenter(this._clientFactory);
    }

    public EntityNavigatorBreadcrumbView navigatorBreadcrumbView(EntityId entityId, SearchParameters searchParameters) {
        return new EntityNavigatorBreadcrumbViewImpl(entityId, searchParameters);
    }

    public EntityId getCurrentLayoutEntityId() {
        return EntityMediator.getInstance().getCurrentLayoutEntityId();
    }

    public EntityId getCurrentEntityId() {
        return EntityMediator.getInstance().getCurrentEntityId();
    }

    public JustEntityAppPage getJustEntityAppPage(EntityDetails entity, SelectedTab selectedTab, PageTitleCallback currentPageTitleCallback, SearchParameters searchParameters) {
        if (this._entityAppPage == null) {
            this._entityAppPage = new JustEntityAppPage(this._clientFactory);
        }
        this._entityAppPage.setEntity(entity, selectedTab, currentPageTitleCallback, searchParameters);
        return this._entityAppPage;
    }

    public void getJustEntityAppPage(EntityId id, SelectedTab selectedTab, PageTitleCallback currentPageTitleCallback, SearchParameters searchParameters, AsyncCallback<JustEntityAppPage> callback) {
        this.controller().getDetailsById(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public JustEntityAppPage getJustEntityAppPage(EntityDetailsPublicData entity, PageTitleCallback currentPageTitleCallback) {
        if (this._entityAppPage == null) {
            this._entityAppPage = new JustEntityAppPage(this._clientFactory);
        }
        this._entityAppPage.setEntity(entity, currentPageTitleCallback);
        return this._entityAppPage;
    }

    public EntityOptionsView getEntityOptionsView() {
        return new EntityOptionsViewImpl(this._clientFactory);
    }

    public EntityMediator mediator() {
        return EntityMediator.getInstance();
    }

    public SearchResultWidget getEntitySearchTabWidget(EntityId entityId, EntityTab entityTab, SearchParameters searchParameters, IsWidget customNoDataView) {
        EntityTabWidgetCacheKey cacheKey = new EntityTabWidgetCacheKey(entityId, entityTab, searchParameters.getContextHierarchy());
        SearchResultWidget cached = (SearchResultWidget)this._entitySearchTabWidgets.get(cacheKey);
        if (cached != null) {
            cached.setSearchParameters(searchParameters);
            cached.setNoDataWidget(customNoDataView);
            return cached;
        }
        EntitySearchTabWidget newWidget = new EntitySearchTabWidget(this._clientFactory, searchParameters, customNoDataView);
        this._entitySearchTabWidgets.put(cacheKey, newWidget);
        return newWidget;
    }

    public SearchResultWidget getEntityNavigatorSearchResultWidget(SearchParameters searchParameters, SearchFilterPresenter filterPresenter, EntityInfo entity) {
        EntityTabWidgetCacheKey cacheKey = new EntityTabWidgetCacheKey((EntityId)entity.getId(), (EntityTab)StaticEntityTab.HIERARCHY, searchParameters.getContextHierarchy());
        SearchResultWidget cached = (SearchResultWidget)this._entitySearchTabWidgets.get(cacheKey);
        if (cached != null) {
            cached.setSearchParameters(searchParameters);
            cached.setSearchFilterCallback((SearchFilterCallback)filterPresenter);
            return cached;
        }
        EntityNavigatorSearchResultWidget newWidget = new EntityNavigatorSearchResultWidget(this._clientFactory, searchParameters, filterPresenter, entity);
        this._entitySearchTabWidgets.put(cacheKey, newWidget);
        return newWidget;
    }

    public void invalidateEntityTabWidgetCache(EntityOverviewHandler.EntityTabWidgetContext context) {
        this._entitySearchTabWidgets.remove(new EntityTabWidgetCacheKey(context.getEntityId(), context.getEntityTab(), context.getContextHierarchy()));
    }
}

